'**********************************
' Telefon-Alarm-Anlage Tonwahl
'**********************************
'Es werden die Analogeingnge auf Vernderung abgefragt, (Bewegungsmelder) und bei Alarm die Rufnummer aktiviert
'Zustzlich kann der Geruschsensor angewhlt werden; Dieser wird allerdings erst beim zweiten Gerusch aktiv
'Nach Anruf wird ein Pieps-Ton gesendet und dann umgeschaltet auf hren
'Nach einem zweiten Piepston kann ber Tastatur die Hupe eingeschaltet werden
'Bedienung
'Wenn das Gert eingeschaltet ist, kann mit der Taste 1 in einer Untermenu verzweigt werden.
'Darber ist es mglich eine bis zu 12 Stellige Nummer einzugeben.Auch nach einem Netzausfall
'ist diese Nummer noch gespeichert.
'Ist die Nummer fertig eingegeben, einfach mit der Taste "*" aus dem Submenu wieder rausgehen.
'Mit der Taste 2 kann die Telefonnummer getestet werden. Dazu muss das Gert an die Telefon-Dose
'angeschlossen werden. Dann wird mit dieser Funktion die eingegeben Nummer gewhlt.
'ber die Funktion 5 kann eine Alarm-Aktiv-Zeit eingegeben werden, in der der Alarm Wochentags automatisch scharf geschaltet wird
'ber die Funktion 6 kann eine Alarm-Aktiv-Zeit eingegeben werden, in der der Alarm Samstags automatisch scharf geschaltet wird
'Ist der Stundenwert auf "0" gesetzt so ist diese Funktion nicht aktiv
'Mit jedem Alarm wird ein Ausgang rausgegeben (Pumpe), um eine Hupe etc. anszuschliessen
'An Sensor_1 und Sensor_2 kann ein beliebiger Alarmeingang angeschlossen werden;
'Wird an Sensor 3 ein Sensor angeschlossen, so erfolgt ein Alarm wenn der Grenzwert berschritten wird;
'Es kann dafr ber die Funktion 3 ein Grenzwert eingegeben werden
'Anlage scharfschalten ber Sensor 4 geffnet (geschlossen = aus)
'Reset Hupe mit "0" im Grundmenu
'Schalter: 1= aus; 2=nur luten; 3=hren; 4=sprechen; 5=Schalten; 6=Anruf mglich 7=Nr 2 ein; 8=Nr 3 ein

'EEprom: 1-12 = Telefonnummer 1: 13=frei; 14-26 = Telefonnummer 2 : 27-40 = Telefonnummer 3
'41= Alarm Stunde ; 42= Alarm Minute; 43= Alarm Dauer; 44= Alarm Stunde Sa; 45= Alarm Minute Sa; 46= Alarm Dauer Sa
'47=Speicher bits; 48=Grenzwert

'Voreinstellungen
define Zugangs_nr_1 0 'Eingabe einer 2-stelligen Zugangsnummer z.B. 67; mssen untersch. Ziffern sein
define Zugangs_nr_2 0 'Bei Eingabe von 00 keine Abfrage
define alarm_wert_mic 2 'Lautstrke ab der Alarm ***
define Telefon_kuerz_laeuten 14 'in Sekunden Telefon wieder auflegen bei nur luten
define wartezeit_geraeusch 0 'in 20ms, d.h. 150 * 20ms = 3000ms = 2sec
define verzoegerung_alarm_1 100 'in 20 ms bei den analogen Eingngen (Kanal 1)
define wiederholung_alarm_1 1 'wie oft wiederholung bis Alarm (Kanal 1)
define verzoegerung_alarm_2 100 'in 20 ms bei den analogen Eingngen (Kanal 2)
define wiederholung_alarm_2 1 'wie oft wiederholung bis Alarm (Kanal 2)
define verzoegerung_alarm_3 100 'in 20 ms bei den analogen Eingngen (Kanal 3)
define wiederholung_alarm_3 1 'wie oft wiederholung bis Alarm (Kanal 3)
define verzoegerung_alarm_4 100 'in 20 ms bei den analogen Eingngen (Kanal 4)
define wiederholung_alarm_4 1 'wie oft wiederholung bis Alarm (Kanal 2)
define Zeit_hoeren 29 'in Sekunden Telefon wieder auflegen bei "hren"
define Zeit_sprechen 44 'in Sekunden Telefon wieder auflegen bei "sprechen"
define Zeit_schalten 60 'in Sekunden Telefon wieder auflegen bei "sprechen"
define Zeit_1_Alarm_Reset 60 '// in Sekunden
define verz_aktiv 30 'verzgerungszeit aktiv
define zeit_bis_naechster_alarm 5 'in Minuten
define anzahl_klingeln 7 'Klingeln bis abheben

' *** Port-Definition ***
define lcd_port byteport[1]
define port1 port[1]	'Hupe laut
define port2 port[2]    'Relais 7
define port3 port[3]    'Re 1 Batterie aus
define port4 port[4]    'Re 2 Solar aus
define port5 port[5]    'Relais 3 Telefon ein
define port6 port[6]    'Relais 4 Verstrker ein
define port7 port[7]    'Relaus 5 Mikro ein
define port8 port[8]    'Relais 6 Alarm_decive_on
define lcd_rs port[9]   'RS0 MT8880
define lcd_rw port[10]  'R/W MT8880
define port11 port[11]  'Takt MT8880
define port12 port[12]
define a_keyb port[13] 'tastatur
define lcd_e port[14]
define clock1 port[15]  'LS374 Datenbergabe
define port_16 port[16]  'CS MT8880

define u_batt AD[1]    '12 Volt
define sensor_0 AD[2]    'Output voltage
define Sensor_1 AD[3]    'Temp Past.
define Sensor_2 AD[4]    'Temp Cooking
define Sensor_3 AD[5]   '
define Sensor_4 AD[6]   '
define Sensor_5 AD[7]
define wahlschalter AD[8]    'Wahlschalter

' *** Bits-Definition ***
define save_byte byte[1]    '
define alarm_micro bit[1]
define Bew_melder_ein bit[2]
define sofort_alarm bit[3]   '
define Grenzwert_ein bit[4]
define nr_2_ein bit[5]   '
define nr_3_ein bit[6]   '
define nur_laeuten bit[7]   '
define hoeren bit[8]   '
define fkt9 bit[9]   'Funktion Handebene
define eing_2_alt bit[10]
define eing_4_alt bit[11]   '
define ext_hupe bit[12]
define meldung_aktiv bit[13]   'Hupe aktiv
define Relais_6 bit[14]
define stelle_1 bit[15]
define FKT1 bit[16]   '
define Relais_4 bit[17]
define Relais_5 bit[18]
define FKT4 bit[19]   '
define keyb_flanke bit[20]
define kein_komma bit[21]       'kein Komma! + Schmierbit
define eingabe_teil_2 bit[22]   'Dateneingabe teil 2
define eingabe_teil_3 bit[23]   'Dateneingabe teil 3
define disp_fkt9 bit[24] 'Nur Anzeige Handebene
define FKT3 bit[25]   '
define Telefonieren_ein bit[26]   '
define aus bit[27]   '
define FKT7 bit[28]   'Funktion Uhreingabe
define FKT8 bit[29]   '
define sprechen bit[30]   '
define fkt5 bit[31]   '
define eing_3_alt bit[32]
define batt_ein bit[33]   '
define eing_1_alt bit[34]
define fkt6 bit[35]   '
define abheben bit[36]   '
define tel_nr bit[37]   '
define FKT2 bit[38]   '
define hupe_ein bit[39]   '

' *** Byte-Definition ***
define display_zaehler byte[6]
define sensor_1_alt byte[7]    '
define sensor_2_alt byte[8]
define sensor_3_alt byte[9]    '
define alarm_schleife byte[10]    '
define naechster_alarm byte[11]
define pointer_eeprom byte[12]          '
define sensor_4_alt byte[13]     '
define aktiv_zeit byte[14]
define freigabe_schalten byte[15]     '
define zaehler_klingeln byte[16]          '
define keyb byte[17]            'Input keyboard
define lcd_param byte[18]       'Daten an LCD
define counter byte[19]  '
define sec_alt byte[20]
define sec_zaehler byte[21]   '
define anzahl_anrufe byte[22]     '
define value word[12]     'Schmier-Flag

'*** Festwerte ***
define volt_10 159	'Batterie ist leer
define volt_10_5 170	'Meldung Batterie ist bald leer
define volt_11 178	'Batterie war leer
define volt_13 210	'Batterie war voll
define volt_14 225	'Batterie ist voll

'Wahlschalter
define wert_pos_1 240 'Position 1
define wert_pos_2 218 'Position 2
define wert_pos_3 187 'Position 3
define wert_pos_4 161 'Position 4
define wert_pos_5 94 'Position 5
define wert_pos_6 55 'Position 6
define wert_pos_7 41 'Position 7
define wert_pos_8 24 'Position 8

'*** ASCII-Codes ***
define A_ &H41
define B_ &H42
define C_ &H43
define D_ &H44
define E_ &H45
define F_ &H46
define G_ &H47
define H_ &H48
define I_ &H49
define J_ &H4A
define K_ &H4B
define L_ &H4C
define M_ &H4D
define N_ &H4E
define O_ &H4F
define P_ &H50
define Q_ &H51
define R_ &H52
define S_ &H53
define T_ &H54
define U_ &H55
define V_ &H56
define W_ &H57
define X_ &H58
define Y_ &H59
define Z_ &H5A

define aa_ &H61
define ae_ &HE1
define bb_ &H62
define cc_ &H63
define dd_ &H64
define ee_ &H65
define ff_ &H66
define gg_ &H67
define hh_ &H68
define ii_ &H69
define jj_ &H6A
define kk_ &H6B
define ll_ &H6C
define mm_ &H6D
define nn_ &H6E
define oo_ &H6F
define oe_ &HEF
define pp_ &H70
define qq_ &H71
define rr_ &H72
define ss_ &H73
define tt_ &H74
define uu_ &H75
define ue_ &HF5
define vv_ &H76
define ww_ &H77
define xx_ &H78
define yy_ &H79
define zz_ &H7A

define null_ &H30
define eins_ &H31
define zwei_ &H32
define drei_ &H33
define vier_ &H34
define fuenf_ &H35
define sechs_ &H36
define sieben_ &H37
define acht_ &H38
define neun_ &H39

define LEERZ &H20
define MINUS &H2D
define NULL &H30
define GLEICH &H3D
define PUNKT &H2E
define HOCHZ &HDF
define DOPPELP &H3A
define Strich &H2D
define Ausr &H21 'Ausrufungszeichen
define fragez &H3F
define Prozent &H25
define schraegstrich &H2F
'define groesser_ &H3E
'define kleiner_ &H3C

' *** Initialisierungen ***
port_16 = on 'Ton-chip deakt
lcd_port = off
Relais_4 = off 'Verstrker aus
gosub output	'erst mal alles aus
gosub LCD_INIT        'Initialisierungen
gosub ton_init 'Ton-wahl chip Init
alarm_micro = off
sofort_alarm = on
open# for write : close# 'zum Initialisieren notwendig
pointer_eeprom = 1 : gosub set_index_eeprom : input# value 'sinnvolle Telefonnumer eingegeben?
if value >=0 and value <= 11 then goto nr_ok 'alle Nummern lschen
for pointer_eeprom = 1 to 40
gosub set_index_eeprom
print# 11 'alles erst mal lschen
next
#nr_ok
pointer_eeprom = 48 : gosub set_index_eeprom : input# value 'sinnvoller Grenzwert eingegeben?
if value > 0 and value < 255 then goto k_grenzw	'Ist schon ein sinnvoller Wert eingegeben?
pointer_eeprom = 48 : gosub set_index_eeprom : print# 0
#k_grenzw
pointer_eeprom = 41 : gosub set_index_eeprom : input# value 'Ist schon ein sinnvoller Wert fr Zeit-Alarm eingegeben?
if value > 0 and value < 25 and value <> 11 then goto load_byte
for pointer_eeprom = 41 to 46
gosub set_index_eeprom : print# 0
next pointer_eeprom
#load_byte
pointer_eeprom = 47 : gosub set_index_eeprom : input# save_byte  'ISDN/analog
Grenzwert_ein = off
gosub eingaenge_init

' *** Zyklisches Programm ***
#loop
gosub Keyboard
gosub time_sec  'Zeitscheibe Sekunde
goto loop

'Zeitscheibe Sekunde
#time_sec
if second = sec_alt then return
sec_alt = second
if second = 4 then gosub time_min
if sec_zaehler < 250 then sec_zaehler = sec_zaehler + 1 'kein berlauf!
if (aus = on or sensor_5 < 20 )and fkt2 = off then gosub auflegen 'bei aus und nicht scharf auflegen!

'if fkt1 = on then gosub display_input
'if fkt2 = ON then gosub waehlen_aktiv
'if fkt3 = ON then gosub display_micro_ein
'if fkt4 = ON then gosub disp_grenzwert
'if fkt5 = ON then gosub display_fkt5
'if fkt6 = ON then gosub display_fkt6
'if fkt7 = on then gosub display_zeit 'Zeiteingabe
if fkt8 = on then gosub display_fkt8
if disp_fkt9 = on and fkt9 = off then gosub Anzeige_Handebene 'Handebene nur Anzeige
'if disp_fkt9 = on then gosub Anzeige_Handebene 'Handebene nur Anzeige
if fkt1 = on or fkt3 = on or fkt4 = on or fkt5 = on or fkt6 = on or fkt7 = on or fkt8 = on then return
if aus = on then naechster_alarm = 0 'kein warten
'if minute >= 1 and u_batt < wert_batt_leer then goto anrufen '//***Batterie leer

gosub anwahl
if wahlschalter = 255 then gosub alarmruf 'Anruf ber Fernbedienung
gosub anruf_annehmen
gosub alarm_abfragen
'gosub Telefon_aktiv
gosub output
gosub reset_alles
'value = freq1 : print value; :print "  ";: value = freq2 : print value'*** nur zum Testen
if fkt1 = off and fkt2 = off and fkt3 = off and fkt4 = off and fkt5 = off and fkt6 = off and fkt7 = off and fkt8 = off and fkt9 = off and disp_fkt9 = off and telefonieren_ein = off then goto display_grundmenu
Return

''Zeitscheibe Minute
#time_min
IF DOW > 6 THEN DOW = 0 'Korrektur Systemfehler fr Wochentag
if telefonieren_ein = off and naechster_alarm > 0 then naechster_alarm = naechster_alarm - 1  'Zeit bis nchster Alarm
'Alarm nach Aktiv_Zeit
if hour = 8 and minute = 1 then Relais_6 = off 'um 8 Uhr frh Licht wieder aus
if minute = 1 and aktiv_zeit > 0 then aktiv_zeit = aktiv_zeit - 1 'alle Stunde Aktiv-zeit dekrement if minute = 1 and
if minute = 1 then anzahl_anrufe = 0
if minute mod 10 = 0 then zaehler_klingeln = 0 'Alle 10 min reset
'Wochentags
pointer_eeprom = 41 : gosub set_index_eeprom : input# keyb 'Stunde
pointer_eeprom = 42 : gosub set_index_eeprom : input# lcd_param 'Minute
pointer_eeprom = 43 : gosub set_index_eeprom : input# value 'Stundenzahl
if dow > 0 and dow < 6 and keyb <> 0 and hour = keyb and minute = lcd_param then aktiv_zeit = value
'samstags
pointer_eeprom = 44 : gosub set_index_eeprom : input# keyb 'Stunde
pointer_eeprom = 45 : gosub set_index_eeprom : input# lcd_param 'Minute
pointer_eeprom = 46 : gosub set_index_eeprom : input# value 'Stundenzahl
if dow = 6 and keyb <> 0 and hour = keyb and minute = lcd_param then aktiv_zeit = value 'Stundenwert Aktivzeit laden
Return

#anwahl
if wahlschalter > wert_pos_1 then aus = on else aus = off 'Schalter Position 1
if wahlschalter < wert_pos_1 and wahlschalter > wert_pos_2 then nur_laeuten = on else nur_laeuten = off 'Schalter Position 2
if wahlschalter < wert_pos_2 and wahlschalter > wert_pos_3 then hoeren = on else hoeren = off 'Schalter Position 3
if wahlschalter < wert_pos_3 and wahlschalter > wert_pos_4 then sprechen = on else sprechen = off 'Schalter Position 4
'if wahlschalter < wert_pos_4 then schalten_ueber_telefon = on else schalten_ueber_telefon = off 'Schalter Position 5
'if wahlschalter < wert_pos_5 and wahlschalter > wert_pos_6 then anruf_annehmen ''Schalter Position 6
if telefonieren_ein = on then return
nr_2_ein = off : nr_3_ein = off
if wahlschalter < wert_pos_6 and wahlschalter > wert_pos_7 then nr_2_ein = on  'Schalter Pos 7
if wahlschalter < wert_pos_7 then nr_3_ein = on  'Schalter Pos 8
return

#Alarmruf
deact port1 : deact port2 : deact port3 ': deact port4
port12 = on 'Eingnge aktivieren
if port1 = on or port2 = on or port3 = on then goto warten
#a_anruf_reset
port12 = off : return
#warten
gosub beep_kurz
lcd_port = 0
deact port1 : deact port2 : deact port3 ': deact port4
if port1 = off and port2 = off and port3 = off then goto a_anruf_reset
nr_2_ein = off : nr_3_ein = off
if port2 = on then nr_2_ein = on
if port3 = on then nr_3_ein = on
port12 = off 'Eingnge deaktivieren
goto alarm2

#anruf_annehmen
if wahlschalter > wert_pos_5 or wahlschalter < wert_pos_6 or telefonieren_ein = on then return
value = freq2 'Anruf beantworten
if wahlschalter < wert_pos_4 and value > 5 then zaehler_klingeln = zaehler_klingeln + 1 'Schalten ber Tel. ein
if zaehler_klingeln > anzahl_klingeln then gosub write_anruf
if zaehler_klingeln > anzahl_klingeln then goto annehmen
return

'Alarm Mikrofon mu mehrmals kommen (Filter gegen anrufen)
#alarm_abfragen
if telefonieren_ein = on or fkt9 = on then return
pointer_eeprom = 41 : gosub set_index_eeprom : input# value 'Stunde
if alarm_micro = on then Relais_5 = on else Relais_5 = off
if aus = on or sec_zaehler < verz_aktiv or naechster_alarm <> 0 or sensor_5 < 20 or anzahl_anrufe >= 3 or (value <> 0 and aktiv_zeit = 0 )then return

if alarm_micro = off then goto bew_alarm 'Mikro nicht ein
'if anzahl_mic_alarm >= 3 then alarm_schleife = 99 'Anzeige das Alarm von Mikro
'if anzahl_mic_alarm >= 3 then goto alarm2
keyb = freq1 : value = freq2
if value < alarm_wert_mic or keyb >= value then goto bew_alarm 'gegen Netzfreq)
gosub lcd_delete
gosub write_alarm
pause wartezeit_geraeusch
keyb = freq1 : value = freq2
if value < alarm_wert_mic or keyb >= value then goto bew_alarm 'gegen Netzfreq)
alarm_schleife = 99
'anzahl_mic_alarm = 0 : gab es Alarm?
'#alarm_mic
'lcd_param=&B00000001 : gosub LCD_WRITECMD
'gosub write_alarm 'print "Alarm"
'anzahl_mic_alarm = anzahl_mic_alarm + 1
'gosub write_leerz : value = anzahl_mic_alarm : kein_komma = ON : gosub WRITEVALUE
'lcd_param = Ausr : gosub LCD_WRITECHAR     '1
goto alarm2

#bew_alarm
if Bew_melder_ein = off then goto eingaenge_alarm
for keyb = 1 to wiederholung_alarm_1
value = abs ( sensor_1 - sensor_1_alt )
if value < 30 then goto kanal_2
pause verzoegerung_alarm_1  'etwas warten als Filter bei Tieren
next
alarm_schleife = 1 : goto alarm2

#kanal_2
for keyb = 1 to wiederholung_alarm_2
value = abs ( Sensor_2 - sensor_2_alt )
if value < 30 then goto kanal_3
pause verzoegerung_alarm_2  'etwas warten als Filter bei Tieren
next
alarm_schleife = 2 : goto alarm2

#kanal_3
for keyb = 1 to wiederholung_alarm_3
value = abs ( sensor_3 - sensor_3_alt )
if value < 30 then goto kanal_4
pause verzoegerung_alarm_3 'etwas warten als Filter bei Tieren
next
alarm_schleife = 3 : goto alarm2

#kanal_4
if Grenzwert_ein = on then goto grenzwert_alarm
for keyb = 1 to wiederholung_alarm_4
value = abs ( sensor_4 - sensor_4_alt )
if value < 30 then goto eingaenge_alarm
pause verzoegerung_alarm_4 'etwas warten als Filter bei Tieren
next
alarm_schleife = 4 : goto alarm2

'Version mit Grenzwert
#grenzwert_alarm
pointer_eeprom = 48 : gosub set_index_eeprom : input# value
if (value < 100 and (sensor_4 -50)/2 > value) or (value > 100 and ((sensor_4 -55)/2) < (value -100 ))then goto alarm_gw else goto eingaenge_alarm
#alarm_gw
alarm_schleife = 4 : goto alarm2 'Sollwert <> Istwert
'if sensor_4 > value then goto alarm2 'Sollwert > Istwert

'Eingnge abfragen
#eingaenge_alarm
deact port1 : deact port2 : deact port3 : deact port4
port12 = on 'Eingnge aktivieren
if eing_1_alt = port1 then goto eingang_2
alarm_schleife = 11 : goto alarm2
#eingang_2
if eing_2_alt = port2 then goto eingang_3
alarm_schleife = 12 : goto alarm2
#eingang_3
if eing_3_alt = port3 then goto eingang_4
alarm_schleife = 13 : goto alarm2
#eingang_4
if eing_4_alt = port4 then goto eingaenge_init
alarm_schleife = 14 : goto alarm2

#eingaenge_init
deact port1 : deact port2 : deact port3 : deact port4
port12 = on 'Eingnge aktivieren
eing_1_alt = port1
eing_2_alt = port2
eing_3_alt = port3
eing_4_alt = port4
port12 = off 'Eingnge aktivieren
return

'Alarm!
#alarm2
if fkt9 = on then return 'Handebene?
gosub lcd_delete
gosub write_Alarm
gosub write_leerz
gosub write_anruf
gosub display_nr
if fkt2 = off then naechster_alarm = zeit_bis_naechster_alarm
'counter = 1
gosub waehlen_aktiv
pause 200 '*** warten bis abgehoben
anzahl_anrufe = anzahl_anrufe + 1
#annehmen
'anzahl_mic_alarm = 0
sec_zaehler = 0 'Zeit Telefonieren Reset
Telefonieren_ein = on
Relais_5 = on 'Mikro ein
abheben = on 'Telefon halten
gosub output '*****
'port_16 = on  'Telefon halten, Whleinrichtung aus
'return

'if fkt9=on or Telefonieren_ein = off then return 'Handebene?

'Beep als Erkennung
'erst 20 Sek Beep; dann 10 Sek hren; dann Beep; dann 10 Sek sprechen; dann 2xBeep; dann 20 Sek schalten
#Telefon_aktiv
'if second = counter then goto schalt_01
'counter = second : sec_zaehler = sec_zaehler + 1

if second mod 2 = 0 and sec_zaehler < 15 then beep 400,25,10 'Beep

'Hren von 15-30 sec
if sec_zaehler <> 15 then goto sprechen
gosub lcd_delete
gosub write_hoeren

#Sprechen
if sec_zaehler <> 30 then goto sprech_2
gosub lcd_delete
gosub write_sprechen
beep 600,25,10 'Beep
#sprech_2
if wahlschalter < wert_pos_4 and sec_zaehler >= 30 and sec_zaehler < 44 then gosub sprechen_on else gosub sprechen_off
'if wahlschalter > wert_pos_3 or sec_zaehler < 30 or sec_zaehler > 39 then Relais_4 = off else relais_4 = on
'if relais_4 = on then relais_5 = on : gosub output

'Schalten ber Telefon
if sec_zaehler <> 45 then goto schalten_schleife
gosub lcd_delete
gosub write_schalten
'if schalten_ueber_telefon = off then goto fertig 'or sofort_alarm = on
'Telefontasten abfragen

'MT880 initialiseren auf Empfang
for keyb= 1 to 2
beep 800,25,10 'Beep
next keyb
port11 = off 'Takt-bit MT8880 aus
lcd_port=&B00000101 'Write Control-Register A tone out, DTMF, no IRQ, Register B aktiv
lcd_rs = on : lcd_rw = off : port_16 = off
gosub daten_mt880 'Daten bergeben
'pause 2
lcd_port=&B00000000 'Burst mode nach Reg.B (nur wenn angewhlt!)
gosub daten_mt880 'Daten bergeben
'pause 2

#schalten_schleife
if second = counter then goto schalt_01 'Sekundenzhler
counter = second : sec_zaehler = sec_zaehler + 1
if sec_zaehler < 46 or sec_zaehler > 60 then goto weiter
#schalt_01

'Wenn keine Tonwahl
'keyb = freq1 : lcd_param = freq2 'kommt Anwahl von Frequenzzhler?
'if value < 1 and lcd_param < 1 then goto tonwahl_switch 'kam irgendwas?
'if sofort_alarm = on then beep 1400,25,10
'beep 1600,25,10
'if sofort_alarm = on then sofort_alarm = off else sofort_alarm = on
'pause 20

#tonwahl_switch
lcd_port = 0
deact port1 : deact port2 : deact port3 : deact port4
lcd_rs = off : lcd_rw = on  'Daten lesen
port11 = on : port11 = on 'Takt aktiv setzen
if lcd_port = 0 then goto schalten_schleife
value = lcd_port 'gesendete Taste
port11 = off 'Takt inaktiv setzen
gosub lcd_delete
kein_komma = ON : gosub WRITEVALUE ': gosub write_leerz

if freigabe_schalten = 2 or (Zugangs_nr_1 = 0 and Zugangs_nr_2 = 0 )then goto freigabe_schalten_ 'Freigabe-Code o.k.?
if freigabe_schalten <> 0 or value <> (Zugangs_nr_1) then goto abfrage_2 '1.Stelle abfragen
freigabe_schalten = 1 : goto schalten_schleife
#abfrage_2
if freigabe_schalten <> 1 or value <> (Zugangs_nr_2) then goto schalten_schleife '2.Stelle abfragen
beep 600,25,10 'Beep
freigabe_schalten = 2 : goto schalten_schleife

#freigabe_schalten_
'if Telefonieren_ein = off then return
if value = 1 then gosub schalten_ein
if value = 2 then gosub schalten_aus
if value = 3 then Relais_6 = on
if value = 4 then Relais_6 = off
'if value = 5 then Relais_5 = on
'if value = 6 then Relais_5 = off
goto schalten_schleife

#weiter
port_16 = on 'Chip abwhlen
if nur_laeuten = on and sec_zaehler > Telefon_kuerz_laeuten then goto auflegen
if hoeren = on and sec_zaehler > Zeit_hoeren then goto auflegen
if sprechen = on and sec_zaehler > Zeit_sprechen then goto auflegen
if (wahlschalter < wert_pos_4  or wahlschalter = 255 ) and sec_zaehler > Zeit_schalten then goto auflegen 'Schalten ber Telefon
goto Telefon_aktiv
'return

#auflegen
Telefonieren_ein = off   'Alarm wieder aktiv
zaehler_klingeln = 0
gosub aus_damit
if fkt2 = off then goto aufl
fkt2 = off : return
#aufl
if sofort_alarm = on then gosub schalten_ein
Relais_6 = on 'Licht einschalten
'weitere Anrufe?
if (wahlschalter > wert_pos_1 and wahlschalter <> 255 )or sensor_5 < 20 then return 'Scharf geschaltet?
pause 20
if (wahlschalter < wert_pos_6 and wahlschalter > wert_pos_7) or wahlschalter < wert_pos_8 or wahlschalter = 255 then return 'Nummer 2,3 wurde schon gewhlt!
gosub schalten_aus
if nr_2_ein = on then goto weiter2
pointer_eeprom = 14: gosub set_index_eeprom : input# value '2.te Telefonnummer eingegeben?
if value = 11 then goto weiter2 'keine Nummer vorhanden
nr_2_ein = on : pause 30 : goto alarm2 'nchsten Anruf aktivieren
#weiter2
if nr_3_ein = on then goto nr_3_off
pointer_eeprom = 27: gosub set_index_eeprom : input# value '2.te Telefonnummer eingegeben?
if value = 11 then goto nr_3_off 'keine Nummer vorhanden
nr_2_ein = off : nr_3_ein = on :pause 30 : goto alarm2 'nchsten Anruf aktivieren
#nr_3_off
nr_3_ein = off
if sofort_alarm = on then gosub schalten_ein
fkt2 = off ': return
return

#reset_alles
if naechster_alarm <> 1 or second < 55 or fkt9=on or wahlschalter > wert_pos_5 or wahlschalter < wert_pos_6 then return 'nicht bei "Anruf mglich"
gosub schalten_aus 'nach xxx Minuten Hupe wieder Aus
#aus_damit
abheben = off
port_16 = on 'MT880 deakt
Relais_4 = off   'Verstrker aus
Relais_5 = off  'Mikro erst mal aus
sec_zaehler = 0 'warten bis nchster Anruf
return

#display_Grundmenu
pointer_eeprom = 41 : gosub set_index_eeprom : input# value 'Stunde
lcd_param = 1 : gosub LCD_GOTOLINE
if aus = on or sec_zaehler < verz_aktiv or naechster_alarm <> 0 or sensor_5 < 20 or anzahl_anrufe >= 3 or (value <> 0 and aktiv_zeit = 0 )then gosub write_inaktiv else gosub write_aktiv
gosub write_leerz
if naechster_alarm = 0 then goto bereit
  value = naechster_alarm
  kein_komma = on
  gosub writevalue
  gosub write_min
gosub write_leerz
goto alarm_wert
#bereit
gosub write_alarm
'lcd_param = doppelp: gosub LCD_WRITECHAR
gosub write_leerz
#alarm_wert
value = alarm_schleife : kein_komma = ON : gosub WRITEVALUE
gosub WRITE_blank

#zeile_2
lcd_param = 2 : gosub LCD_GOTOLINE
if wahlschalter <= wert_pos_1 or wahlschalter = 255 then goto zeile2_2
gosub write_alarm
gosub write_leerz
gosub write_off
#zeile2_2
if nur_laeuten = on then gosub write_nur_laeuten
if hoeren = on then gosub write_hoeren
if sprechen = on then gosub write_sprechen
if wahlschalter <> 255 then goto grundm_1
gosub write_alarm
lcd_param = rr_    : gosub LCD_WRITECHAR
lcd_param = uu_    : gosub LCD_WRITECHAR
lcd_param = ff_    : gosub LCD_WRITECHAR
#grundm_1
if wahlschalter < wert_pos_4 and wahlschalter > wert_pos_5 then gosub write_schalten
if wahlschalter > wert_pos_5 or wahlschalter < wert_pos_6 then goto grundm_2
gosub write_anruf
gosub write_moeglich
#grundm_2
if nr_2_ein <> on and nr_3_ein <> on then goto mic
gosub write_nr
if nr_2_ein = on then lcd_param = zwei_ else lcd_param = drei_
gosub LCD_WRITECHAR: gosub write_leerz
gosub write_ein
#mic
'gosub write_leerz
'gosub write_mik
'lcd_param = Doppelp   : gosub LCD_WRITECHAR     '1
'value = freq1 : kein_komma = ON : gosub WRITEVALUE
gosub write_leerz : gosub write_leerz : gosub write_leerz '
goto write_blank '
'return

'Funktion Keyboard
#Keyboard
a_keyb = ON     'Ausgang Keyboard aktiv
deact port1 : deact port2 : deact port3 : deact port4 : deact port5 : deact port6 : deact port7 : deact port8
deact lcd_rs : deact lcd_rw : deact port11 : deact port12

keyb = &HFF        'auf Anfangswert setzen
if port3 = ON then keyb= 5     'Tasten abfragen
if port4 = ON then keyb= 2
if port5 = ON then keyb= 11
if port6 = ON then keyb= 9
if port7 = ON then keyb= 6
if port8 = ON then keyb= 3
if port2 = ON then keyb= 8
if port1 = ON then keyb= 0
if lcd_rs = ON then keyb= 1
if lcd_rw = ON then keyb= 4
if port11 = ON then keyb= 7
if port12 = ON then keyb= 10
a_keyb = off 'Ausgang Keyboard Aktiv aus

if keyb_flanke = ON and keyb <> &HFF then goto aktiv                      'Flanke keyboard
if keyb = &HFF then keyb_flanke = ON : return
#aktiv
keyb_flanke = off

if FKT1 = ON or FKT2 = ON or FKT3 = ON or FKT4 = ON or fkt8 = on or disp_fkt9 = on then goto k002 'im Grundmenu?
if keyb <> 0 then goto k002
meldung_aktiv = off : hupe_ein = off : ext_hupe = off : Relais_6 = off 'Reset Alarm-meldung und Hupe im Grundmenu
#k002 'ist schon eine Funktion angewhlt?
if keyb = 10 then goto reset                   'Abbruch Taste?
if fkt1 = ON then goto eing_1                  'Eingabe luft Tel-Number?
if fkt3 = ON then goto eing_3                  '
if fkt4 = ON then goto eing_4                  '
if fkt5 = ON then goto eing_5                  '
if fkt6 = ON then goto eing_6                  '
if fkt7 = ON then goto eing_7                  '
if fkt8 = ON then goto eing_8                  '
if disp_fkt9 = ON then goto eing_9                  'Eingabe luft Hand?

'Anzeige Tel-Number
if keyb <> 1 then goto key2
fkt1 = ON
gosub lcd_delete
stelle_1 = off
#display_input
gosub write_Telefon_Nr
gosub display_nr
return

'Eingabe Nummer
#eing_1
if stelle_1 = on then goto f1_1 'bei der ersten Eingabe alles lschen
stelle_1 = on
pointer_eeprom = 1
if nr_2_ein = on then pointer_eeprom = 14
if nr_3_ein = on then pointer_eeprom = 27
gosub set_index_eeprom
value = 11 'alles erst mal lschen
for lcd_param = 1 to 16
print# value
pointer_eeprom = pointer_eeprom + 1
next lcd_param
pointer_eeprom = 1
if nr_2_ein = on then pointer_eeprom = 14
if nr_3_ein = on then pointer_eeprom = 27
#f1_1
if keyb = 11 then return
gosub set_index_eeprom : print# keyb:
pointer_eeprom = pointer_eeprom + 1
goto display_input

'Calling
#key2
if keyb <> 2 then goto key3
gosub lcd_delete
     lcd_param = T_    : gosub LCD_WRITECHAR
     lcd_param = ee_    : gosub LCD_WRITECHAR
     lcd_param = ss_    : gosub LCD_WRITECHAR
     lcd_param = tt_    : gosub LCD_WRITECHAR
     lcd_param = ausr    : gosub LCD_WRITECHAR
     pause 30
fkt2 = ON
goto alarm2
'gosub write_anrufen
'gosub display_nr
'gosub waehlen_aktiv
'return

'Mikro/Bewg_melder/Hupe ein?
#key3
if keyb <> 3 then goto key4
fkt3 = on : gosub lcd_delete 'Anzeige lschen
#display_micro_ein
     lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile des Displays wird aktiviert
     gosub write_mik
'     lcd_param = rr_    : gosub LCD_WRITECHAR
'     lcd_param = oo_    : gosub LCD_WRITECHAR
'     gosub write_leerz
'     gosub write_alarm
     lcd_param = doppelp : gosub LCD_WRITECHAR
     if alarm_micro = off then gosub write_off else gosub write_ein
     lcd_param = schraegstrich  : gosub LCD_WRITECHAR

     lcd_param = B_    : gosub LCD_WRITECHAR
     lcd_param = ee_    : gosub LCD_WRITECHAR
     lcd_param = ww_    : gosub LCD_WRITECHAR
     lcd_param = gg_    : gosub LCD_WRITECHAR
     lcd_param = doppelp : gosub LCD_WRITECHAR
     if Bew_melder_ein = off then gosub write_off else gosub write_ein

     lcd_param = 2 : gosub LCD_GOTOLINE
     gosub write_hupe
'     gosub write_leerz
'     gosub write_ein
     lcd_param = doppelp : gosub LCD_WRITECHAR
     if sofort_alarm = off then gosub write_off else gosub write_ein
lcd_param=&B00001111 : gosub LCD_WRITECMD'**** Cursor blinken ein
if eingabe_teil_2 = off then lcd_param=&B10000100 else lcd_param=&B10001101 'Cursor auf best. Position
if eingabe_teil_3 = on then lcd_param=&B11000101
gosub LCD_WRITECMD
return

'Micro ein
#eing_3
if eingabe_teil_2 = on then goto bewg
if eingabe_teil_3 = on then goto sofort_1
if keyb = 11 then goto mik_1 'Taste "#"
if keyb = 1 then alarm_micro = on else alarm_micro = off : goto display_micro_ein
#mik_1
eingabe_teil_2 = on : goto display_micro_ein
'Bewegungsmelder
#bewg
if keyb = 11 then goto bewg_2
if keyb = 1 then Bew_melder_ein = on else Bew_melder_ein = off : goto display_micro_ein
#bewg_2
eingabe_teil_2 = off : eingabe_teil_3 = on : goto display_micro_ein
'Alarm-Hupe
#sofort_1
if keyb = 11 then goto sofort_2
if keyb = 1 then sofort_alarm = on else sofort_alarm = off : goto display_micro_ein
#sofort_2
eingabe_teil_3 = off : goto display_micro_ein


'Grenzwert Eingabe
#key4
if keyb <> 4 then goto key5 'Anzeige nur Status Ausgnge
fkt4 = ON : gosub lcd_delete
#disp_grenzwert
    lcd_param = 1 : gosub LCD_GOTOLINE
    lcd_param = G_    : gosub LCD_WRITECHAR     '5
    lcd_param = rr_    : gosub LCD_WRITECHAR     '6
    lcd_param = ee_    : gosub LCD_WRITECHAR     '7
    lcd_param = nn_    : gosub LCD_WRITECHAR     '8
    lcd_param = zz_    : gosub LCD_WRITECHAR     '1
    lcd_param = ww_    : gosub LCD_WRITECHAR     '2
'    lcd_param = ee_    : gosub LCD_WRITECHAR     '8
'    lcd_param = rr_    : gosub LCD_WRITECHAR     '1
'    lcd_param = tt_    : gosub LCD_WRITECHAR     '2
    lcd_param = Doppelp    : gosub LCD_WRITECHAR
    if Grenzwert_ein = on then gosub write_ein else gosub write_off

    #line_2
    lcd_param = 2 : gosub LCD_GOTOLINE
    lcd_param = I_    : gosub LCD_WRITECHAR     '2
    lcd_param = ss_    : gosub LCD_WRITECHAR     '8
    lcd_param = tt_    : gosub LCD_WRITECHAR     '1
    lcd_param = Doppelp    : gosub LCD_WRITECHAR
    value = (sensor_4 -55) / 2 :if value < 0 then value = 0 : kein_komma = ON : gosub WRITEVALUE        'Pumpzeit
'    value = sensor_4  :if value < 0 then value = 0 : kein_komma = ON : gosub WRITEVALUE        'Pumpzeit
    gosub WRITE_LEERZ
    lcd_param = S_    : gosub LCD_WRITECHAR
    lcd_param = oo_    : gosub LCD_WRITECHAR
    lcd_param = ll_    : gosub LCD_WRITECHAR : gosub LCD_WRITECHAR
    lcd_param = Doppelp    : gosub LCD_WRITECHAR
    pointer_eeprom = 48 : gosub set_index_eeprom : input# value
    kein_komma = ON : gosub WRITEVALUE        'Pumpzeit
lcd_param=&B00001111 : gosub LCD_WRITECMD'**** Cursor blinken ein
if eingabe_teil_2 = off then lcd_param=&B10000111 else lcd_param=&B11001101 'Cursor auf best. Position
gosub LCD_WRITECMD
    return

'Eingabe Grenzwert
#eing_4
if eingabe_teil_2 = on then goto grenzw_2
if keyb = 11 then goto grenzw_1
if keyb = 1 then Grenzwert_ein = on else Grenzwert_ein = off
goto disp_grenzwert
#grenzw_1
eingabe_teil_2 = on : stelle_1 = off : goto disp_grenzwert

#grenzw_2
if keyb = 11 then goto grenzw_3'keine neue Eingabe?
if stelle_1 = ON then goto stelle_2
stelle_1 = ON : pointer_eeprom = 48 : gosub set_index_eeprom : print# keyb : goto disp_grenzwert
#stelle_2
if keyb = 11 then grenzw_3 'Zeichen #?
pointer_eeprom = 48 : gosub set_index_eeprom : input# value
value =  (10 * value) + keyb : gosub set_index_eeprom : print# value :  goto disp_grenzwert
#grenzw_3
eingabe_teil_2 = off : goto disp_grenzwert

'Alarmzeit Wochentage
#key5
if keyb <> 5 then goto key6 '
fkt5 = ON : gosub lcd_delete
#display_fkt5
    lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile anw.
    gosub write_alarm
    gosub write_leerz   '5
    keyb = 41 'pointer EEprom
    goto write_an_ab_fuer

'Eingabe Zeit Timer
#eing_5
counter = 41
goto eingabe_alarm_zeit

'Alarmzeit Samstag
#key6
if keyb <> 6 then goto key7 '
fkt6 = ON : gosub lcd_delete
#display_fkt6

    lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile anw.
    lcd_param = S_    : gosub LCD_WRITECHAR     '1
    lcd_param = aa_    : gosub LCD_WRITECHAR     '1
    gosub write_leerz
    lcd_param = A_    : gosub LCD_WRITECHAR     '1
    lcd_param = ll_    : gosub LCD_WRITECHAR     '1
    lcd_param = aa_    : gosub LCD_WRITECHAR     '1
    gosub write_leerz   '5
    keyb = 44 'pointer EEprom
    goto write_an_ab_fuer

'Eingabe Zeit Timer Sa
#eing_6
counter = 44
goto eingabe_alarm_zeit

'Eingabe Uhrzeit
#key7
if keyb <> 7 then goto key8                  '
fkt7 = ON : gosub lcd_delete 'Display lschen
#display_zeit
    lcd_param = 1 : gosub LCD_GOTOLINE           '2.Zeile anw.
    lcd_param = Z_    : gosub LCD_WRITECHAR     '1
    lcd_param = ee_    : gosub LCD_WRITECHAR     '2
    lcd_param = ii_    : gosub LCD_WRITECHAR     '3
    lcd_param = tt_    : gosub LCD_WRITECHAR     '4
    lcd_param = Doppelp    : gosub LCD_WRITECHAR     '5
    gosub write_std
    gosub write_leerz
    gosub write_min
    gosub write_leerz
    lcd_param = W_    : gosub LCD_WRITECHAR     '3
    lcd_param = oo_    : gosub LCD_WRITECHAR     '3
    lcd_param = T_    : gosub LCD_WRITECHAR     '4

    lcd_param = 2 : gosub LCD_GOTOLINE           '2.Zeile anw.
gosub write_blank
'    for lcd_param = 1 to 5 : gosub write_leerz :next ': gosub write_leerz : gosub write_leerz : gosub write_leerz : gosub write_leerz
    value = hour  : kein_komma = ON : gosub WRITEVALUE    'Anzeige Uhrzeit hour
    lcd_param = DOPPELP : gosub LCD_WRITECHAR
    value = minute : kein_komma = ON : gosub WRITEVALUE              'minute
    gosub write_leerz : gosub write_leerz : gosub write_leerz
    value = dow : kein_komma = ON : gosub WRITEVALUE    'Anzeige Uhrzeit hour
lcd_param=&B00001111 : gosub LCD_WRITECMD'**** Cursor blinken ein
if eingabe_teil_2 = off then lcd_param=&B11000110 else lcd_param=&B11001001 'Cursor auf best. Position
if eingabe_teil_3 = on then lcd_param=&B11001110
gosub LCD_WRITECMD
    return

'Eingabe Zeit
#eing_7
if eingabe_teil_2 = on then goto eing_teil_2
if eingabe_teil_3 = on then goto eing_teil_3

if keyb = 11 then goto h01  'Eingabe Stunde
if stelle_1 = off then hour = keyb else hour = (10 * hour ) + keyb
stelle_1 = on : goto display_zeit
#h01
stelle_1 = OFF : eingabe_teil_2 = on : goto display_zeit

#eing_teil_2			'Eingabe Minute
if keyb = 11 then goto h02 'keine neue Eingabe?
if stelle_1 = off then minute = keyb else minute = (10 * minute ) + keyb
stelle_1 = on  : goto display_zeit
#h02
stelle_1 = OFF : eingabe_teil_2 = off : eingabe_teil_3 = on : goto display_zeit

#eing_teil_3			'Eingabe Wochentag
if keyb = 11 then goto end_inp_time 	'keine neue Eingabe?
if keyb > 6 then goto write_nein
if keyb < 7 then dow = keyb '0 = Sonntag, 6=Sa

#end_inp_time
stelle_1 = OFF :eingabe_teil_3 = off :goto display_zeit

'Spannung
#key8
if keyb <> 8 then goto key9
fkt8 = ON : gosub lcd_delete  'Display lschen
#display_fkt8
    lcd_param = 1       : gosub lcd_gotoline    '2.Zeile des Displays wird aktiviert
    lcd_param = U_    : gosub LCD_WRITECHAR
    lcd_param = strich    : gosub LCD_WRITECHAR
    lcd_param = A_    : gosub LCD_WRITECHAR
    lcd_param = uu_    : gosub LCD_WRITECHAR
    lcd_param = ss_ : gosub LCD_WRITECHAR
    lcd_param = gg_    : gosub LCD_WRITECHAR
    lcd_param = DOPPELP    : gosub LCD_WRITECHAR
    value = sensor_0 : gosub spannungswert : gosub WRITEVALUE       'Batteriespannung
'    value = 77*(sensor_0-55)/156+28 : gosub WRITEVALUE       'Ausgangspg: Y=77*(x-55)/156+25
    lcd_param = V_    : gosub LCD_WRITECHAR
    gosub write_leerz
return

#eing_8
return

'Handebene
#key9
if keyb <> 9 then return
gosub lcd_delete
disp_fkt9 = on
#Anzeige_Handebene
    lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile anw.
    lcd_param = V_    : gosub LCD_WRITECHAR
    lcd_param = ee_    : gosub LCD_WRITECHAR
    lcd_param = rr_    : gosub LCD_WRITECHAR
gosub write_leerz
gosub write_mik
gosub write_leerz
gosub write_hupe
gosub write_leerz
    lcd_param = T_    : gosub LCD_WRITECHAR
    lcd_param = ee_    : gosub LCD_WRITECHAR
    lcd_param = ll_    : gosub LCD_WRITECHAR

 lcd_param = 2 : gosub LCD_GOTOLINE
 lcd_param = eins_    : gosub LCD_WRITECHAR
 if relais_4 = ON then lcd_param = A_ else lcd_param = pp_ : gosub LCD_WRITECHAR
gosub write_leerz :gosub write_leerz
 lcd_param = zwei_    : gosub LCD_WRITECHAR
 if relais_5 = ON then lcd_param = A_ else lcd_param = pp_ : gosub LCD_WRITECHAR
gosub write_leerz :gosub write_leerz : gosub write_leerz
 lcd_param = drei_    : gosub LCD_WRITECHAR
 if ext_hupe = ON then lcd_param = A_ else lcd_param = pp_  : gosub LCD_WRITECHAR
gosub write_leerz :gosub write_leerz
 lcd_param = vier_    : gosub LCD_WRITECHAR
 if abheben = ON then lcd_param = A_ else lcd_param = pp_  : gosub LCD_WRITECHAR
return

#eing_9
fkt9 = on
if keyb <> 1 then goto m_fkt_3 'Relais_4 ein
if Relais_4 = off then Relais_4 = on else Relais_4 = off
goto Anzeige_Handebene

#m_fkt_3 'Relais_5 ein
if keyb <> 2 then goto m_fkt_4
if Relais_5 = off then Relais_5 = on else Relais_5 = off
goto Anzeige_Handebene

#m_fkt_4 'ext. Hupe
if keyb <> 3 then goto m_fkt_5
if ext_hupe = off then ext_hupe = on else ext_hupe = off
goto Anzeige_Handebene

#m_fkt_5 'abheben
if keyb <> 4 then return
if abheben  = off then abheben = on else abheben = off
goto Anzeige_Handebene

#Reset
if fkt3 = off and fkt4 = off and fkt8 = off then goto reset_1 'ISDN-Anwahl speichern
value = save_byte
pointer_eeprom = 47 : gosub set_index_eeprom : print# value 'ISDN/analog

#reset_1
gosub lcd_delete
lcd_param=&B00001100 : gosub LCD_WRITECMD' Cursor blinken aus
fkt1=off : fkt2=off :fkt3 = OFF : fkt4 = OFF : fkt5 = OFF: fkt6 = OFF
fkt7 = OFF : fkt8 = OFF : fkt9 = OFF : disp_fkt9 = off
stelle_1 = OFF  : eingabe_teil_2 = off : eingabe_teil_3 = off
meldung_aktiv = off : return  'Funktion aus und Ende

#display_nr
tel_nr = on
lcd_param = 2 : gosub LCD_GOTOLINE
pointer_eeprom = 1
if nr_2_ein = on then pointer_eeprom = 14
if nr_3_ein = on then pointer_eeprom = 27
    gosub set_index_eeprom
    display_zaehler = 1
#next_number
    input# value
    if value = 11 then goto end_display
    kein_komma = on : gosub WRITEVALUE
    display_zaehler = display_zaehler + 1
    pointer_eeprom = pointer_eeprom + 1
    if display_zaehler < 15 then goto next_number
#end_display
    for display_zaehler = 1 to 15
    lcd_param = LEERZ : gosub LCD_WRITECHAR
    next
    tel_nr = off
    return

'anrufen
#waehlen_aktiv
'Relais_5 = on 'Mic aus
if fkt2 = on then relais_4 = on 'Lautsprecher zum Testen ein
'lcd_port = 0
'port12 = on 'Eingnge aktivieren
'#deact port1 : deact port2 : deact port3 ': deact port4
'if wahlschalter = 255 and port2 = on then nr_2_ein = on
'if wahlschalter = 255 and port3 = on then nr_3_ein = on
'port12 = off 'Eingnge aktivieren
abheben = on : gosub output
port11 = off 'Takt
pause 80 'voreinst.: 180 bis Freizeichen
lcd_port=&B00001001 'Write Control-Register A tone out, DTMF, no IRQ, Register B aktiv
lcd_rs = on : lcd_rw = off : port_16 = off
gosub daten_mt880 'Daten bergeben
pause 2
lcd_port=&B00000000 'Burst mode nach Reg.B (nur wenn angewhlt!)
gosub daten_mt880 'Daten bergeben
pause 4
if nr_2_ein = on then goto pointer_nr_2
if nr_3_ein = on then goto pointer_nr_3
goto pointer_nr_1

#pointer_nr_2
for pointer_eeprom = 14 to 26 'Zeiger Numer 2
goto next_value

#pointer_nr_3
for pointer_eeprom = 27 to 39 'Zeiger Numer 3
goto next_value

#pointer_nr_1
port11 = off : lcd_rs = off : lcd_rw = off : port_16 = off
for pointer_eeprom = 1 to 12 'Zeiger Numer 1

#next_value
gosub set_index_eeprom : input# value
if value = 11 then goto end_call
if value = 0 then value = 10 'wenn Nr = 0 dann 10 pulses

lcd_port = value 'An Tonwahl-chip
gosub daten_mt880 'Daten bergeben
'deact port1 : deact port2 : deact port3 : deact port4
'lcd_rs = on : lcd_rw = on 'Status-Register lesen
'gosub daten_mt880 'Daten bergeben
'Wenn bit 1 gesetzt ist nchster Ton
pause 30 ' *** von 30 gendert! 840 ms
if pointer_eeprom = 1 or pointer_eeprom = 14 or pointer_eeprom = 27 then pause 60 'wegen Amtsholung etw. lnger warten
next

#end_call
port_16 = on 'Chip deakt
return
'if fkt2 = off then return
'fkt2 = off
'pause 255 'Wenn nur Test
'pause 255 'Wenn nur Test
'goto aus_damit

'Leerzeichen schreiben
#WRITE_LEERZ
lcd_param = LEERZ    : gosub LCD_WRITECHAR : return

'Wert Batterie umrechnen
'#batt_value
'value =  121*(value-89)/144+77  'Y=12,1*(X-89)/144+7,7
'return

#sprechen_on
Relais_4 = on : Relais_5 = off : return 'Verstrker ein; Solange sprechen sicherheitshalber Mikro aus
#sprechen_off
Relais_4 = off : Relais_5 = on : return'Verstrker aus, Mikro ein

#schalten_ein
hupe_ein = on : ext_hupe = on
return 'Alarm-Hupe ein
#schalten_aus
hupe_ein = off : ext_hupe = off
return 'Alarm-Hupe ein

#write_Telefon_Nr
    lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile anw.
    lcd_param = T_    : gosub LCD_WRITECHAR     '1
    lcd_param = ee_    : gosub LCD_WRITECHAR     '1
    lcd_param = ll_    : gosub LCD_WRITECHAR     '1
    lcd_param = strich    : gosub LCD_WRITECHAR     '1
gosub write_nr
    gosub write_leerz
    lcd_param = eins_
    if nr_2_ein = on then lcd_param = zwei_
    if nr_3_ein = on then lcd_param = drei_
    gosub LCD_WRITECHAR
    lcd_param = Doppelp    : gosub LCD_WRITECHAR
    gosub write_leerz : gosub write_leerz : gosub write_leerz : gosub write_leerz
return

#write_an_ab_fuer
    lcd_param = aa_    : gosub LCD_WRITECHAR     '2
    lcd_param = nn_    : gosub LCD_WRITECHAR     '3
    gosub write_leerz
    lcd_param = aa_    : gosub LCD_WRITECHAR     '2
    lcd_param = bb_    : gosub LCD_WRITECHAR     '3
    lcd_param = Doppelp    : gosub LCD_WRITECHAR     '3
    lcd_param = ff_    : gosub LCD_WRITECHAR     '7
    lcd_param = ue_    : gosub LCD_WRITECHAR     '7
    lcd_param = rr_    : gosub LCD_WRITECHAR
    lcd_param = 2 : gosub LCD_GOTOLINE           '2.Zeile anw.
    gosub write_blank
'    for lcd_param = 1 to 5 : gosub write_leerz :next 'gosub write_leerz :gosub write_leerz :gosub write_leerz : gosub write_leerz
    pointer_eeprom = keyb : gosub set_index_eeprom : input# value 'su_hour
    kein_komma = ON : gosub WRITEVALUE
    lcd_param = DOPPELP     : gosub LCD_WRITECHAR     '1
    pointer_eeprom = keyb + 1 : gosub set_index_eeprom : input# value 'su_minute
    kein_komma = ON  : gosub WRITEVALUE
    gosub write_leerz
    pointer_eeprom = keyb + 2 :  gosub set_index_eeprom : input# value  'an fuer ...
    kein_komma = ON : gosub WRITEVALUE
    gosub write_std
    gosub write_blank
lcd_param=&B00001111 : gosub LCD_WRITECMD'**** Cursor blinken ein
if eingabe_teil_2 = off then lcd_param=&B11000110 else lcd_param=&B11001001 'Cursor auf best. Position
if eingabe_teil_3 = on then lcd_param=&B11001100
gosub LCD_WRITECMD
    Return

#eingabe_alarm_zeit
if eingabe_teil_2 = on then goto su_eing_teil_2
if eingabe_teil_3 = on then goto su_eing_teil_3

if stelle_1 = ON then goto su_stelle2          'Eingabe Stunde
if keyb = 11 then goto su_01 	'keine neue Eingabe?
pointer_eeprom = counter : gosub set_index_eeprom : Print# keyb 'su_hour
    stelle_1 = ON : goto end '1.Stelle
#su_stelle2
if keyb = 11 then goto su_01  'Zeichen #?
    pointer_eeprom = counter : gosub set_index_eeprom : input# value 'su_hour
    value =  (10 * value ) + keyb
    gosub set_index_eeprom : print# value : goto end
#su_01
stelle_1 = OFF : eingabe_teil_2 = on : eingabe_teil_3 = off : goto end

#su_eing_teil_2                                 'Eingabe Minute
if stelle_1 = ON then goto su_2_stelle2
if keyb = 11 then goto end_su_02 	'keine neue Eingabe?
pointer_eeprom = counter + 1 :  gosub set_index_eeprom : print# keyb
    stelle_1 = ON : goto end  '1.Stelle
#su_2_stelle2
if keyb = 11 then goto end_su_02  'Zeichen #?
pointer_eeprom = counter + 1 :  gosub set_index_eeprom : input# value
    value =  (10 * value) + keyb
    gosub set_index_eeprom : print# value : goto end
#end_su_02
 stelle_1 = OFF : eingabe_teil_2 = off : eingabe_teil_3 = on :goto end

'Eingabe Dauer
#su_eing_teil_3                                 'Eingabe Dauer
if stelle_1 = ON then goto su_3_stelle2
if keyb = 11 then goto end_su_03	'keine neue Eingabe?
pointer_eeprom = counter + 2:  gosub set_index_eeprom : print# keyb
    stelle_1 = ON : goto end '1.Stelle
#su_3_stelle2
if keyb = 11 then goto end_su_03  'Zeichen #?
pointer_eeprom = counter + 2 :  gosub set_index_eeprom : input# value
    value =  (10 * value ) + keyb
    gosub set_index_eeprom : print# value : goto end
#end_su_03
 stelle_1 = OFF : eingabe_teil_3 = off
#end
if fkt5 = on then goto display_fkt5 else goto display_fkt6

#write_Alarm
    lcd_param = A_    : gosub LCD_WRITECHAR     '1
    lcd_param = ll_    : gosub LCD_WRITECHAR     '1
    lcd_param = aa_    : gosub LCD_WRITECHAR     '1
    lcd_param = rr_    : gosub LCD_WRITECHAR     '1
    lcd_param = mm_    : gosub LCD_WRITECHAR     '1
return

#write_mik
     lcd_param = M_    : gosub LCD_WRITECHAR
     lcd_param = ii_    : gosub LCD_WRITECHAR
     lcd_param = kk_    : gosub LCD_WRITECHAR
return

#write_Anruf
    lcd_param = A_    : gosub LCD_WRITECHAR     '1
    lcd_param = nn_    : gosub LCD_WRITECHAR     '1
    lcd_param = rr_    : gosub LCD_WRITECHAR     '1
    lcd_param = uu_    : gosub LCD_WRITECHAR     '1
    lcd_param = ff_    : gosub LCD_WRITECHAR     '1
return

#write_nr
    lcd_param = N_    : gosub LCD_WRITECHAR     '1
    lcd_param = rr_    : gosub LCD_WRITECHAR     '3
return

#write_inaktiv
  lcd_param = ii_    : gosub LCD_WRITECHAR
  lcd_param = nn_    : gosub LCD_WRITECHAR
#write_aktiv
  lcd_param = aa_    : gosub LCD_WRITECHAR
  lcd_param = kk_    : gosub LCD_WRITECHAR
  lcd_param = tt_    : gosub LCD_WRITECHAR
  lcd_param = ii_    : gosub LCD_WRITECHAR
  lcd_param = vv_    : gosub LCD_WRITECHAR
  return

#write_alarm_aus
  lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile anw.
  gosub write_alarm
  gosub write_leerz
#write_off
     lcd_param = aa_    : gosub LCD_WRITECHAR     '11
     lcd_param = uu_    : gosub LCD_WRITECHAR  '12
     lcd_param = ss_    : gosub LCD_WRITECHAR : return

#write_ein
  lcd_param = ee_    : gosub LCD_WRITECHAR
  lcd_param = ii_    : gosub LCD_WRITECHAR
  lcd_param = nn_    : gosub LCD_WRITECHAR :return

#write_blank
for value = 1 to 5
gosub write_leerz
next value
return

#write_nur_laeuten
'  lcd_param = nn_    : gosub LCD_WRITECHAR
'  lcd_param = uu_    : gosub LCD_WRITECHAR
'  lcd_param = rr_    : gosub LCD_WRITECHAR
'  gosub write_leerz
  lcd_param = ll_    : gosub LCD_WRITECHAR
  lcd_param = ae_    : gosub LCD_WRITECHAR
  lcd_param = uu_    : gosub LCD_WRITECHAR
  lcd_param = tt_    : gosub LCD_WRITECHAR
  gosub write_en
 return

#write_hoeren
  lcd_param = hh_    : gosub LCD_WRITECHAR
  lcd_param = oe_    : gosub LCD_WRITECHAR
  lcd_param = rr_    : gosub LCD_WRITECHAR
gosub write_en
  gosub write_leerz: gosub write_leerz : return

#write_sprechen
  lcd_param = ss_    : gosub LCD_WRITECHAR
  lcd_param = pp_    : gosub LCD_WRITECHAR
  lcd_param = rr_    : gosub LCD_WRITECHAR
  lcd_param = ee_    : gosub LCD_WRITECHAR
  lcd_param = cc_    : gosub LCD_WRITECHAR
  lcd_param = hh_    : gosub LCD_WRITECHAR
  gosub write_en :return

#write_schalten
  lcd_param = ss_    : gosub LCD_WRITECHAR
  lcd_param = cc_    : gosub LCD_WRITECHAR
  lcd_param = hh_    : gosub LCD_WRITECHAR
  lcd_param = aa_    : gosub LCD_WRITECHAR
  lcd_param = ll_    : gosub LCD_WRITECHAR
  lcd_param = tt_    : gosub LCD_WRITECHAR
gosub write_en : return

#write_moeglich
    gosub write_leerz
    lcd_param = mm_    : gosub LCD_WRITECHAR     '7
    lcd_param = oe_    : gosub LCD_WRITECHAR     '7
    lcd_param = gg_    : gosub LCD_WRITECHAR
    lcd_param = ll_    : gosub LCD_WRITECHAR : return

#write_nein
  lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile anw.
  lcd_param = N_    : gosub LCD_WRITECHAR
  gosub write_ein
  lcd_param = Ausr    : gosub LCD_WRITECHAR: pause 50 :return

#write_en
  lcd_param = ee_    : gosub LCD_WRITECHAR
  lcd_param = nn_    : gosub LCD_WRITECHAR :return

#write_std
    lcd_param = S_    : gosub LCD_WRITECHAR
    lcd_param = tt_    : gosub LCD_WRITECHAR
    lcd_param = dd_    : gosub LCD_WRITECHAR :return

#write_min
    lcd_param = M_    : gosub LCD_WRITECHAR
    lcd_param = ii_    : gosub LCD_WRITECHAR
    lcd_param = nn_    : gosub LCD_WRITECHAR :return
return

#write_hupe
    lcd_param = H_    : gosub LCD_WRITECHAR
    lcd_param = uu_    : gosub LCD_WRITECHAR
    lcd_param = pp_    : gosub LCD_WRITECHAR
    lcd_param = ee_    : gosub LCD_WRITECHAR
return

#spannungswert
value =  121*(value-82)/144+77  'Y=12,1*(X-89)/144+7,7
return

#beep_kurz
ext_hupe = on : gosub output : pause 300 : ext_hupe = off : return

#set_index_eeprom
sys &h93 &h819d,&hB7CB,&hB692,&hB7CA,&hB691,pointer_eeprom + pointer_eeprom - 2 : return 'Zeiger 0; 2; 4; 6 etc

#lcd_delete
lcd_param=&B00000001 : gosub LCD_WRITECMD : return

#ton_init
'  port_16 = on 'Chip aktivieren
  port11 = off ' Clock auf 0
  lcd_port=&B00000000 '1
  lcd_rs = on : lcd_rw= on : port_16 = off '1 +Chip enable
  gosub daten_mt880 'Daten bergeben
  lcd_rw= off '2
  gosub daten_mt880 'Daten bergeben
'  lcd_rw= off '3
  gosub daten_mt880 'Daten bergeben
  lcd_port=&B00001000 '4
  gosub daten_mt880 'Daten bergeben
  lcd_port=&B00000000 '5
  gosub daten_mt880 'Daten bergeben
  lcd_rw= on '6
  deact port1 : deact port2 : deact port3 : deact port4
  gosub daten_mt880 'Daten bergeben
  pause 10
  port_16 = on 'Chip disable
return

#daten_mt880
port11 = off : port11 = on : port11 = on : port11 = off
return

'*** LCD_Initialisierung ***
#LCD_INIT
  lcd_e = off       'Instruction-Mode
  pause 20
  lcd_port = 0 ' alle ports 0
  lcd_port=&B00000010 : lcd_e=1 : lcd_e=0 'mit 8-Bit-Command in 4-Bit-Modus umschalten
  lcd_param=&B00101100 : gosub LCD_WRITECMD' Zeilen und Font einstellen
  lcd_param=&B00001100 : gosub LCD_WRITECMD'Display an
  lcd_param=&B00000001 : gosub LCD_WRITECMD'Display lschen
  lcd_port= &B00000110 : gosub LCD_WRITECMD 'Auto inkrement
'  lcd_param = C_    : gosub LCD_WRITECHAR
'  lcd_param = aa_    : gosub LCD_WRITECHAR
'  lcd_param = rr_    : gosub LCD_WRITECHAR
'  lcd_param = pp_    : gosub LCD_WRITECHAR
'  lcd_param = ee_    : gosub LCD_WRITECHAR
'   gosub write_leerz
'  lcd_param = D_    : gosub LCD_WRITECHAR
'  lcd_param = ii_    : gosub LCD_WRITECHAR
'  lcd_param = ee_    : gosub LCD_WRITECHAR
'  lcd_param = mm_    : gosub LCD_WRITECHAR
'  lcd_param = &H21    : gosub LCD_WRITECHAR '!

  lcd_param = 2 : gosub LCD_GOTOLINE           '1.Zeile anw.
  lcd_param = V_    : gosub LCD_WRITECHAR 'Versions-Kennung

'  gosub WRITE_LEERZ
  lcd_param = zwei_    : gosub LCD_WRITECHAR : return ':  pause 90

'LCD-Programme
#WRITEVALUE
if abs(value) >= 1000 then lcd_param = NULL + ((value mod 10000)/1000) else goto w01 ' Tausender-Dezimalstelle
gosub LCD_WRITECHAR
#w01
if abs(value) >= 100 then lcd_param = NULL + ((value mod 1000)/100) else goto  w02 ' Hunderter-Dezimalstelle
gosub LCD_WRITECHAR
#w02
if tel_nr = on then goto eine_ziffer
if abs(value) >= 10 then lcd_param = NULL + ((value mod 100)/10) else lcd_param = null ' Zehner-Dezimalstelle mit einer fhrenden 0
gosub LCD_WRITECHAR
goto w03
#eine_ziffer
if abs(value) >= 10 then lcd_param = NULL + ((value mod 100)/10) else goto w03 ' Zehner-Dezimalstelle mit einer fhrenden 0
gosub LCD_WRITECHAR
#w03
if kein_komma = ON then goto w001
lcd_param = punkt :gosub lcd_writechar

#w001
kein_komma = OFF
lcd_param = NULL + value mod 10 ' einer Dezimalstelle ohne Leerzeichen
gosub LCD_WRITECHAR
return

' Zeilenwechsel
#LCD_GOTOLINE
  if lcd_param = 1 then lcd_param = &H80 : if lcd_param = 2 then lcd_param = &HC0
  goto LCD_WRITECMD

' LCD-Kommando
#LCD_WRITECMD
  lcd_rs=0 : lcd_rw=0 :  goto LCD_WRITE	'//kann ev. spter entfallen

' Zeichenausgabe
#LCD_WRITECHAR
  lcd_rs=1 : lcd_rw = 0 '//kann ev. entfallen

' Kommando oder Zeichen an Display senden
#LCD_WRITE
  lcd_port = lcd_param shr 4  :  lcd_e = 1 : lcd_e = 0 ' Hi-Nibble
  lcd_port = lcd_param and &H0F : lcd_e = 1 : lcd_e = 0 ' Lo-Nibble
lcd_port = off: clock1 = off
return

'Ausgnge rausgeben
#output
port_16 = on 'DTMF-Dekoder
sensor_1_alt = sensor_1
sensor_2_alt = sensor_2
sensor_3_alt = sensor_3
sensor_4_alt = sensor_4
'if Relais_5 = on then Relais_4 = off 'Lautsprecher aus
lcd_port = off
port1 = hupe_ein
port2 = ext_hupe 'Relais 7
port3 = on 'Relais 1 Batterie
'port4 = off 'Relais 2 Solar aus
port5 = abheben 'Relais 3
port6 = Relais_4 'Verstrker
port7 = Relais_5 'Mic
port8 = Relais_6  'Relais 6
pulse clock1 'bergabe an 74LS373
return

