'**********************************
' Durchlauferhitzer
'**********************************
'Bedienungen:
'Grundmenu 0 = Alarmmeldung quit, Alarm-Hupe aus
'keine Schaltuhr: eingabe von 0 min
'Beep: Schaltuhr, Alarmanlage
'Reset Alarm: 0 im Grundmenu eingeben
'Handebene: Funktion 9 angewhlt: nur Anzeige Status Ausgnge;
'           eine Taste drcken: alle Ausgnge werden jetzt ber Hand gesteuert
'Mit * im Grundmenu von Hand Heizen starten
'Mit Taster aufheizen unterdrcken

'Daten in EEPROM:
'1 = Zeit insg. verfahren
'2 = Anzahl Kanle
'3 = Schaltuhr Stunde
'4 = Schaltuhr Minute
'5 = Schaltuhr Ein-Zeit
'6 = Khltemperatur Solarzelle
'7 = bits speichern
'8-19 Telefonnumer
'20 = Schaltdauer Bewegungsmelder
'21 = Umin Batterie
'22 = Umax Batterie
'Menu: Bewegungsm, , Temp:Soll Ist
'Schalt-Zeit,
'Zeit, , Hand

'R1: Relais zum Abschalten der angeschlossenen Verbraucher bei minimaler Spannung; Lastabwurf Kanal 1
'R2: Relais zum Abschalten der Solarzelle bei voller Batterie
'R3: Lastabwurf Kanal 2
'R4: Lastabwurf Kanal 3
'R5:
'R6: Schaltausgang fr Lampensteuerung ber Bewegungsmelder
'R7: Schaltausgang fr Schaltuhr

'*** Festwerte ***
define Temp_hysterese 8 'Hysterese fr Solarzellen khlen 1 Digit = 0.9 Grad

' *** Port-Definition ***
define lcd_port byteport[1]
define port1 port[1]	'Hupe laut / Verfahren Grundschalter
define port2 port[2]    'Relais 7 / Leermeldung Khl-Wasser
define port3 port[3]    'Batterie aus /Tr-Diebstahlschutz
define port4 port[4]    'Solar aus
define port5 port[5]    'Relais 3
define port6 port[6]    'Relais 4
define port7 port[7]    'Relais 5
define port8 port[8]    'Relais 6
define lcd_rs port[9]
define lcd_rw port[10]
define port11 port[11]
define port12 port[12]
define a_keyb port[13] 'Tastatur aktivieren
define lcd_e port[14] 'Puls LCD-Display
define clock1 port[15]  'LS374 Datenbergabe
define port_16 port[16]  'Whlvorrichtung aktiveren

define u_batt AD[1]    'Batteriespannung
define u_ausg AD[2]    'Regelbare Spannung
define Sensor_1 AD[3]  'Bewegungsmelder
define Sensor_2 AD[4]  'Taster aus
define Sensor_3 AD[5]
define Sensor_temp AD[6] 'Temperatur-Sensor
define Sensor_Solar AD[7] 'Solarzelle Diebstahlschutz
define wahlschalter AD[8]

'define da1 DA[1] 'Puls/Breite-Ausgang
'define da2 DA[2] 'Puls/Breite-Ausgang

' *** Bits-Definition ***
define save_eeprom_flags byte[1]    'Bits 1-8 ->EEprom
define n_links_on bit[1] 'Verfahren
define position_ein bit[2]   'Positionierung ein; Freigabe vom Anwender
define solar_off bit[3]  'Relais Batterie voll
define kuehlen bit[4]   'Khlen ein; Freigabe vom Anwender
define taster_aus bit[5]     'Flussberwachung Khlen
'define saeure bit[6]     'Anzeige Zeit
define flanke_alarm_solar bit[7] 'Diebstahlsicherung
define alarm_tuere bit[8] '
define Relais_3 bit[9]   'Zwischenspeicher fr den Ausgang
define leermeldung bit[10]  'Option Khlen: Wenn Leermeldung vom Behlter
define fkt1 bit[11]   'Funktion
define FKT2 bit[12]   'Funktion
define fkt3 bit[13]   'Funktion
define FKT4 bit[14]   'Funktion
define fkt5 bit[15]   'Funktion
define FKT6 bit[16]   'Funktion
define FKT7 bit[17]   'Funktion Uhreingabe
define fkt8 bit[18]       'Umschaltung Sekunden zhlen fr Pasteurisierung
define fkt9 bit[19]   'Funktion Handebene
define meldung_aktiv bit[20]   'Hupe aktiv
define flanke_alarm_batt bit[21]   'Flanke Batterie bald leer
define flanke_alarm_tuer bit[22]     'Alarm Diebstahlsicherung abschalten
define tuerschalter bit[23]   'fr Alarm
define batt_ein bit[24] 'Relais Batt ein
define batt_puls_laden  bit[25]  'Solar laden pulsen
define stelle_1 bit[26] 'fr Dateneingabe
define pump bit[27] 'Relais Pumpe
define n_links bit[28] 'Verfahren nach links
define n_rechts bit[29] 'Verfahren nach rechts
define schaltuhr bit[30] 'Relais
define grundpos bit[31] 'Eingang Grundpos
define keyb_flanke bit[32]
define kein_komma bit[33]       'kein Komma bei Anzeige
define eingabe_teil_2 bit[34]   'Dateneingabe teil 2
define eingabe_teil_3 bit[35]   'Dateneingabe teil 3
define verfahren_war_aktiv bit[36]  '
'define bit[37]
define disp_fkt9 bit[38] 'Nur Anzeige Handebene
define tel_nr bit[39] 'nur fr die Diplay-Anzeige

' *** Byte-Definition ***
define sec_alt byte[6]    'Sekunden-Zhler Flanke
'define byte[7]     '
define su_time_act byte[8]     'Schaltuhr Zeit ein aktuell
define old_voltage_Solar byte[9] 'fr Diebstahlberwachung
define keyb byte[10]    'Eingabe Tastatur
define lcd_param byte[11]       'Daten an LCD
'define zeit_pumpe_ein byte[12]  'fr berwachung Wasserfluss
define verfahrzeit  byte[13]     'Verfahren Zeitgeber
'define alarm_temp_alt byte[14]     'Temperaturwert vor Pumpen
define sensor_1_alt byte[15] 'Fr Telefon-Anruf
define pointer_eeprom byte[16] 'Zeiger fr EEprom
define Bew_melder_aktiv byte[17]
define zeit_ein_sec byte[18]   'Fr Bewegungsmelder Vergleich
define summe_ah_1 word[10]   'byte 19 und 20;
define zeit_ein word[11]   'byte 21 und 22;
define value word[12]     'Schmier-Flag byte 23+24

define wert_pos_1  240 'Wahlschalter
define wert_pos_2  218 'Wahlschalter
define wert_pos_3  187 'Wahlschalter
define wert_pos_4  161 'Wahlschalter
define wert_pos_5  94 'Wahlschalter
define wert_pos_6  55 'Wahlschalter
define wert_pos_7  41 'Wahlschalter
define wert_pos_8  24 'Wahlschalter

'*** ASCII-Codes ***
define A_ &H41
define B_ &H42
define C_ &H43
define D_ &H44
define E_ &H45
define F_ &H46
define G_ &H47
define H_ &H48
define I_ &H49
define J_ &H4A
define K_ &H4B
define L_ &H4C
define M_ &H4D
define N_ &H4E
define O_ &H4F
define P_ &H50
define Q_ &H51
define R_ &H52
define S_ &H53
define T_ &H54
define U_ &H55
define V_ &H56
define W_ &H57
define X_ &H58
define Y_ &H59
define Z_ &H5A

define aa_ &H61
define ae_ &HE1
define bb_ &H62
define cc_ &H63
define dd_ &H64
define ee_ &H65
define ff_ &H66
define gg_ &H67
define hh_ &H68
define ii_ &H69
define jj_ &H6A
define kk_ &H6B
define ll_ &H6C
define mm_ &H6D
define nn_ &H6E
define oo_ &H6F
define oe_ &HEF
define pp_ &H70
define qq_ &H71
define rr_ &H72
define ss_ &H73
define tt_ &H74
define uu_ &H75
define ue_ &HF5
define vv_ &H76
define ww_ &H77
define xx_ &H78
define yy_ &H79
define zz_ &H7A

define null_ &H30
define eins_ &H31
define zwei_ &H32
define drei_ &H33
define vier_ &H34
define fuenf_ &H35
define sechs_ &H36
define sieben_ &H37
define acht_ &H38
define neun_ &H39

define LEERZ &H20
define MINUS &H2D
define NULL &H30
define GLEICH &H3D
define PUNKT &H2E
define HOCHZ &HDF
define DOPPELP &H3A
define Strich &H2D
define Ausr &H21 'Ausrufungszeichen
define fragez &H3F
define Prozent &H25
define schraegstrich &H2F

' *** Initialisierungen ***
'print "ATS0=1" 'Modem auf Antwort-Modus
batt_ein = on : gosub output 'Batterie erst mal ein
gosub LCD_INIT  'LCD Initialisierungen
open# for write : close# ' Initialisiere Datei ohne was zu schreiben
pointer_eeprom = 3 : gosub set_index_eeprom : input# value 'Schaltuhr Stunde
if value > 0 and value <= 24 then goto init_2 'sinnvoller Wert fr Schaltuhr?
pointer_eeprom = 3 : gosub set_index_eeprom : print# 0  'Schaltuhr auf 0 setzen
pointer_eeprom = 4 : gosub set_index_eeprom : print# 0
pointer_eeprom = 5 : gosub set_index_eeprom : print# 0
#init_2
pointer_eeprom = 3 : gosub set_index_eeprom : input# value 'Schaltuhr Stunde
if value > 0 and value <= 24 then goto loop 'sinnvoller Wert fr Schaltuhr?
for value = 3 to 5 : pointer_eeprom = value : gosub set_index_eeprom : print# 0 : next 'Schaltuhr auf 0 setzen

' *** Zyklisches Programm ***
#loop
gosub Keyboard
gosub time_sec  'Zeitscheibe Sekunde
goto loop

'Zeitscheibe Sekunde
#time_sec
if second = sec_alt then return
sec_alt = second
if second = 59 then gosub time_min  'Zeitscheibe Minute
if minute mod 2 = 0 and second = 10 then second = second - 1 'Korrektur Zeit alle zwei Minuten = 12 Min pro Tag
if fkt9 = on or fkt5 = on then goto weit1 'Hand aktiv oder Telefonnummern-Eingabe
gosub eingaenge 'Eingnge lesen
'gosub nachfuehrung 'Sonnennachfhrung
pointer_eeprom = 20 : gosub set_index_eeprom : input# value 'Schaltzeit Bewegungsmelder
if Sensor_2 > 200 then taster_aus = on 'Aus-Taster bettigt extern
if Sensor_2 > 200 then gosub bew_aktiv 'Aus-Taster bettigt
if Bew_melder_aktiv <> 1 then goto weit2
taster_aus = off : Bew_melder_aktiv = 0 'Reset ausschalter
'if Bew_melder_aktiv > 0 and (value <= 100 or (value > 100 and value <= 200 and second = 2)or (value > 200 and second = 1 and minute = 1)) then Bew_melder_aktiv = Bew_melder_aktiv - 1 'Ein-Zeit
#weit2
pointer_eeprom = 5 : gosub set_index_eeprom : input# keyb 'Zeit Schaltuhr
if (keyb <= 100 or (keyb > 100 and second = 1 )or (keyb > 200 and second = 1 and minute = 1)) and su_time_act > 0 then su_time_act = su_time_act - 1 'Schaltuhr Sek oder Min zhlen?
gosub schaltuhr
if schaltuhr = on then zeit_ein_sec = zeit_ein_sec + 1
if zeit_ein_sec >= 60 then zeit_ein = zeit_ein + 1
if zeit_ein_sec >= 60 then zeit_ein_sec = 0
'gosub solar_kuehlen
'gosub wasser_alarm
gosub Bewegungsmelder
gosub Temperatur_Steuerung

#weit1
'if fkt5 = on then return 'Tel-Nummern Eingabe
'if fkt6 = on then gosub display_fkt6 'Test anrufen
if fkt8 = on then gosub display_fkt8 '**** Anzeige der Temp/Spgswerte; nach Test entfernen!
if disp_fkt9 = on and fkt9 = off then gosub Anzeige_Handebene 'Handebene aktiv aber nur Anzeige
gosub output 'Ausgnge ansteuern
goto Grundmenue       'Anzeige Display Grundfunktionen
Return

'Zeitscheibe Minute
#time_min
if Bew_melder_aktiv > 0 then Bew_melder_aktiv = Bew_melder_aktiv - 1 'Ein-Zeit
gosub Data_to_pc
Return

'Zeit-Schaltuhr aktivieren
#schaltuhr
pointer_eeprom = 5 : gosub set_index_eeprom : input# keyb 'Einschaltzeit
if su_time_act <> 0 then n_links= on else n_links= off
pointer_eeprom = 3: gosub set_index_eeprom : input# value 'Schaltuhr Stunde
if hour <> value then return '
pointer_eeprom = 4: gosub set_index_eeprom : input# value 'Schaltuhr Minute
if minute <> value or second > 5 then return '
if keyb > 200 then keyb = keyb - 200 'Einschaltzeit
if keyb > 100 and keyb < 200 then keyb = keyb - 100
su_time_act = keyb 'Einschaltzeit neu aktivieren
return

#Bewegungsmelder
'if Bew_melder_aktiv >< 0 then n_links = on else n_links = off '
'if n_links = on then return 'Funktion schon aktiv
keyb = abs ( sensor_1 - sensor_1_alt ) 'Bewegung registriert?
if keyb > 60 then goto bew_aktiv 'nderung am Analog-Eingang Bewegungsmelder?
sensor_1_alt = sensor_1 : return
#bew_aktiv
pointer_eeprom = 20 : gosub set_index_eeprom : input# value 'Schaltdauer Bewegungsmelder
if value > 100 then value = value - 100 'Wenn Eingabe Schaltdauer Bewegungsmelder in Std
if value > 100 then value = value - 100 'Wenn Eingabe Schaltdauer Bewegungsmelder in Minuten
Bew_melder_aktiv = value 'Neuen Wert laden
return

#Temperatur_Steuerung
pointer_eeprom = 20 : gosub set_index_eeprom : input# lcd_param 'Schaltdauer Bewegungsmelder
pointer_eeprom = 6 : gosub set_index_eeprom : input# value 'Soll-Temperatur
value = ((value* 10) + 365) / 5 'Umrechnung auf Eingabe-Wert
if sensor_temp < ( value - Temp_hysterese ) and (Bew_melder_aktiv >< 0 or lcd_param = 0 )then schaltuhr = on 'mit oder ohne Bew-Melder
if sensor_temp > value or ( Bew_melder_aktiv = 0 and lcd_param <> 0) or taster_aus = on then schaltuhr = off 'mit oder ohne Bew-Melder
return

'Daten an den PC senden
#Data_to_pc
value = (sensor_temp * 5)-365 :  print value ;" ";
print Bew_melder_aktiv ;" " ;
if schaltuhr = on then print 1 else print 0
1'value = sensor_solar : gosub solar_spannungs_wert : print value ;" " ; 'Solar-Spannung
'value = strom_Sensor_1 : gosub strom_wert : print value ;" " ; 'Strom
'value = strom_Sensor_2 : gosub strom_wert : print value 'optional 2.Stromsensor
'value = u_batt : gosub spannungs_wert : print value 'Batteriespannung
return

#Grundmenue
if fkt1 = on or fkt2 = on or fkt3 = on or fkt4 = on or fkt5 = on or fkt6 = on or fkt7 = on or fkt8 = on or disp_fkt9 = on then return 'andere FKT angew?
if meldung_aktiv = on then goto line_2  'wird Meldung gerade angezeigt?
    lcd_param = 1 : gosub LCD_GOTOLINE  '1.Zeile des Displays wird aktiviert
    lcd_param = T_    : gosub LCD_WRITECHAR
    lcd_param = ee_   : gosub LCD_WRITECHAR
    lcd_param = mm_   : gosub LCD_WRITECHAR
    lcd_param = pp_ : gosub LCD_WRITECHAR
    lcd_param = Doppelp     : gosub LCD_WRITECHAR
    value = (sensor_temp * 5)-365 :  gosub WRITEVALUE 'alt:397
    lcd_param = HOCHZ    : gosub LCD_WRITECHAR
    lcd_param = C_    : gosub LCD_WRITECHAR
    gosub write_leerz ': gosub write_leerz :  gosub write_leerz
if schaltuhr = on then gosub write_on else gosub write_off
'    value = sensor_solar : gosub solar_spannungs_wert : gosub WRITEVALUE
'    lcd_param = V_    : gosub LCD_WRITECHAR
'    gosub write_leerz
'   if disp_watt = on then goto anzeige_watt
'   if disp_ah = on then goto anzeige_ah
'    value = strom_Sensor_1 : gosub strom_wert : gosub WRITEVALUE
'    lcd_param = A_ : gosub LCD_WRITECHAR
'    gosub write_leerz : gosub write_leerz : gosub write_leerz

#line_2
    lcd_param = 2 : gosub LCD_GOTOLINE  '2.Zeile des Displays wird aktiviert
    lcd_param = E_    : gosub LCD_WRITECHAR
    lcd_param = ii_   : gosub LCD_WRITECHAR
    lcd_param = nn_   : gosub LCD_WRITECHAR
    lcd_param = Doppelp     : gosub LCD_WRITECHAR
    value = zeit_ein  :kein_komma = on: gosub WRITEVALUE
    lcd_param = mm_ : gosub LCD_WRITECHAR
    lcd_param = ii_    : gosub LCD_WRITECHAR
    lcd_param = nn_   : gosub LCD_WRITECHAR
    gosub write_leerz
'    value = Bew_melder_aktiv  :kein_komma = on : gosub WRITEVALUE

'    value = hour  : kein_komma  = ON : gosub WRITEVALUE    'Anzeige Uhrzeit hour
'    if second mod 2 <> 0 then lcd_param = Leerz else lcd_param = Doppelp
'    gosub LCD_WRITECHAR
'    value = minute : kein_komma  = ON : gosub WRITEVALUE              'minute
'    gosub WRITE_LEERZ :  gosub write_leerz
return

'Funktion Keyboard
#Keyboard
a_keyb = ON     'Ausgang Keyboard aktiv
deact port1
deact port2
deact port3
deact port4
deact port5
deact port6
deact port7
deact port8
deact lcd_rs
deact lcd_rw
deact port11
deact port12

keyb = &HFF        'auf Anfangswert setzen
if port3 = ON then keyb= 5     'Tasten abfragen
if port4 = ON then keyb= 2
if port5 = ON then keyb= 11
if port6 = ON then keyb= 9
if port7 = ON then keyb= 6
if port8 = ON then keyb= 3
if port2 = ON then keyb= 8
if port1= ON then keyb= 0
if lcd_rs = ON then keyb= 1
if lcd_rw = ON then keyb= 4
if port11 = ON then keyb= 7
if port12 = ON then keyb= 10
a_keyb = OFF 'Ausgang Keyboard Aktiv aus

if keyb_flanke = ON and keyb <> &HFF then goto aktiv   'Flanke keyboard
if keyb = &HFF then keyb_flanke = ON : return
#aktiv
keyb_flanke = OFF
if fkt1 = ON or fkt2 = on or fkt3 = on or FKT4 = ON or fkt5 = ON or FKT6 = on or FKT7 = on or FKT8 = on or disp_fkt9 = on then goto k00
if keyb = 0 then taster_aus = on 'Auschalten
if keyb = 0 then gosub bew_aktiv
if keyb = 10 then schaltuhr = on 'Mit * im Grundmenu von Hand starten
if keyb = 10 then gosub bew_aktiv 'Aktiv-Zeit laden
if keyb = 10 then schaltuhr = on 'Mit * im Grundmenu von Hand starten
if keyb = 10 then taster_aus = off
'Anzeige umschalten;  Funktionen im Grundmenu
'if keyb <> 11 then goto k00   'Taste #
'if disp_watt = off and disp_ah = off then goto k21
'if disp_watt = on then goto k22
'if disp_ah = on then goto k23
#k21
'disp_watt = on : return 'Anzeige Batterie-Spannnung
#k22
'disp_watt = off : disp_ah = on : return 'Anzeige Zeit
#k23
'disp_ah = off : return 'Anzeige Temp Past

#k00
'Alarm aus Reset mit Eingabe von "0" im Grundmenu
if keyb <> 0 then goto k001 'im Grundmenu?
meldung_aktiv = off : port1 = off 'Reset Alarm-meldung und Hupe im Grundmenu
flanke_alarm_solar = off

#k001
if keyb = 10 then goto reset                   'Abbruch Taste?
if fkt1 = ON then goto eing_1                   'Eingabe luft Pumpzeit?
'if fkt2 = ON then goto eing_2                  'Eingabe luft Timer?
if fkt3 = on then goto eing_3
if fkt4 = on then goto eing_4                  'Spannungsanzeige
'if fkt5 = on then goto eing_5		'Eingabe Tauchsieder
'if fkt6 = on then goto eing_6                       'Eingabe luft Verfahren
if fkt7 = ON then goto eing_7                  'Eingabe luft Uhr?
if fkt8 = ON then goto eing_8                  '
if disp_fkt9 = ON then goto eing_9             'Eingabe luft Hand?

'Schaltzeit Bewegungsmelder
#key1
if keyb <> 1 then goto key2
fkt1 = on : gosub del_lcd 'Anzeige lschen
#display_fkt1
    lcd_param = 1 : gosub LCD_GOTOLINE
    lcd_param = B_    : gosub LCD_WRITECHAR
    lcd_param = ee_    : gosub LCD_WRITECHAR
    lcd_param = ww_    : gosub LCD_WRITECHAR
    lcd_param = Punkt    : gosub LCD_WRITECHAR
    lcd_param = M_    : gosub LCD_WRITECHAR
    lcd_param = ee_    : gosub LCD_WRITECHAR
    lcd_param = ll_    : gosub LCD_WRITECHAR
    lcd_param = dd_    : gosub LCD_WRITECHAR
    lcd_param = ee_    : gosub LCD_WRITECHAR
    lcd_param = rr_    : gosub LCD_WRITECHAR
'    lcd_param = doppelp    : gosub LCD_WRITECHAR
    lcd_param = 2 : gosub LCD_GOTOLINE
pointer_eeprom = 20 : gosub set_index_eeprom : input# value : kein_komma = on : gosub WRITEVALUE
gosub write_leerz
'if value <= 100 then gosub write_sec
gosub write_min
'if value > 100 and value <= 200 then gosub write_min
'if value > 200 then gosub write_std
gosub write_leerz : gosub write_leerz : gosub write_leerz
lcd_param=&B00001111 : gosub LCD_WRITECMD'Cursor blinken ein
lcd_param=&B11000000  'Cursor auf best. Position
gosub LCD_WRITECMD
return

#eing_1
if keyb = 11 then goto pu_end_teil_2 'keine neue Eingabe?
if stelle_1 = ON then goto p_2_stelle_2
pointer_eeprom = 20: gosub set_index_eeprom : print# keyb  'Daten-zeiger EEPROM auf 20 setzen
stelle_1 = ON : goto display_fkt1 '1.Stelle
#p_2_stelle_2
pointer_eeprom = 20: gosub set_index_eeprom : input# value 'alten Wert lesen
value = (10 * value) + keyb : gosub set_index_eeprom : print# value : goto display_fkt1 'weitere Daten nach EEprom
#pu_end_teil_2
stelle_1 = OFF : eingabe_teil_2 = off  : goto display_fkt1
return

'Verfahr-Zeit
#key2
if keyb <> 2 then goto key3
return
'fkt2 = ON  : gosub del_lcd '
'#display_fkt2
'     lcd_param=1 : gosub LCD_GOTOLINE
'     gosub write_rotate
'     lcd_param = Doppelp    : gosub LCD_WRITECHAR
'     if position_ein = on then gosub write_on else gosub write_off

'     lcd_param=2 : gosub LCD_GOTOLINE
'     gosub write_time
'     lcd_param = doppelp : gosub LCD_WRITECHAR
'     open# for read : input# value : close# : kein_komma = on : gosub WRITEVALUE 'Verfahrzeit aus EEprom
'     lcd_param = ss_ : gosub LCD_WRITECHAR
'     gosub WRITE_LEERZ
'lcd_param=&B00001111 : gosub LCD_WRITECMD 'Cursor blinken ein
'if eingabe_teil_2 = off then lcd_param=&B10000111 else lcd_param=&B11000101 'Cursor auf best. Position
'gosub LCD_WRITECMD
'return

'Verfahren ein
'#eing_2
'if eingabe_teil_2 = on then goto v_teil_2
'if keyb <> 11 then goto verf04 'Weiter mit nchster Eingabe bei #?
'eingabe_teil_2 = on: stelle_1 = off : goto display_fkt2
'#verf04
'if keyb = 1 then position_ein = on else position_ein = off
'goto display_fkt2

'Eingabe Verfahrzeit
'#v_teil_2
'if keyb = 11 then goto v_reset	'keine neue Eingabe
'if stelle_1 = on then goto verf_stelle_2
'pointer_eeprom = 1 : gosub set_index_eeprom : print# keyb 'Verfahrzeit
'stelle_1 = on : goto display_fkt2
'#verf_stelle_2
'open# for read : input# value : close# 'alten Wert lesen
'value = (10 * value) + keyb : pointer_eeprom = 1 : gosub set_index_eeprom : print# value :goto display_fkt2 'weitere Daten nach EEprom
'#v_reset
'eingabe_teil_2 = off : stelle_1 = off : goto display_fkt2

'Alarm
#key3
if keyb <> 3 then goto key4
fkt3 = ON : gosub del_lcd'Display lschen
#display_fkt3
    lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile des Displays wird aktiviert
    lcd_param = 1 : gosub LCD_GOTOLINE
    lcd_param = T_    : gosub LCD_WRITECHAR
    lcd_param = ee_    : gosub LCD_WRITECHAR
    lcd_param = mm_    : gosub LCD_WRITECHAR
    lcd_param = pp_    : gosub LCD_WRITECHAR
    lcd_param = doppelp : gosub LCD_WRITECHAR
    lcd_param = I_    : gosub LCD_WRITECHAR
    lcd_param = ss_    : gosub LCD_WRITECHAR
    lcd_param = tt_    : gosub LCD_WRITECHAR
    gosub write_leerz
    lcd_param = S_    : gosub LCD_WRITECHAR
    lcd_param = oo_    : gosub LCD_WRITECHAR
    lcd_param = ll_    : gosub LCD_WRITECHAR : gosub LCD_WRITECHAR
     lcd_param = 2 : gosub LCD_GOTOLINE           '2.Zeile des Displays wird aktiviert
     gosub write_leerz
     gosub write_leerz
     gosub write_leerz
    value = (sensor_temp * 5)-365 :  gosub WRITEVALUE
'     value = (Sensor_2 * 5)-365:  gosub WRITEVALUE       'Temperatur Ist
     lcd_param = HOCHZ    : gosub LCD_WRITECHAR
     lcd_param = C_    : gosub LCD_WRITECHAR
     gosub WRITE_LEERZ
     gosub write_leerz
     pointer_eeprom = 6 : gosub set_index_eeprom : input# value 'Temperatur
     kein_komma = ON : gosub WRITEVALUE
     lcd_param = HOCHZ    : gosub LCD_WRITECHAR
     lcd_param = C_    : gosub LCD_WRITECHAR
     gosub write_leerz
lcd_param=&B00001111 : gosub LCD_WRITECMD 'Cursor blinken ein
lcd_param=&HCB'Cursor auf best. Position
gosub LCD_WRITECMD
return

'Eingabe fkt3
#eing_3
if keyb = 11 then goto display_fkt3 'Stunde
if stelle_1 = ON then goto fkt5_stelle2
pointer_eeprom = 6 : gosub set_index_eeprom :print# keyb
    stelle_1 = ON : goto display_fkt3 '1.Stelle
#fkt5_stelle2
    pointer_eeprom = 6 : gosub set_index_eeprom : input# value
    value =  (10 * value ) + keyb
    gosub set_index_eeprom : print# value : goto display_fkt3
'    #end_fkt5
'    eingabe_teil_2 = off
'    goto display_fkt3

'Schaltuhr
#key4
if keyb <> 4 then goto key5
fkt4 = ON  : gosub del_lcd 'Display loeschen
#display_fkt4
    lcd_param = 1 : gosub LCD_GOTOLINE
    lcd_param = S_  : gosub LCD_WRITECHAR
    lcd_param = cc_ : gosub LCD_WRITECHAR
    lcd_param = hh_ : gosub LCD_WRITECHAR
    lcd_param = aa_ : gosub LCD_WRITECHAR
    lcd_param = ll_ : gosub LCD_WRITECHAR
    lcd_param = tt_ : gosub LCD_WRITECHAR
    lcd_param = uu_    : gosub LCD_WRITECHAR
    lcd_param = hh_    : gosub LCD_WRITECHAR
    lcd_param = rr_    : gosub LCD_WRITECHAR

    lcd_param = 2 : gosub LCD_GOTOLINE           '2.Zeile anw.
    pointer_eeprom = 3 : gosub set_index_eeprom : input# value 'Stunde aus EEprom
    kein_komma = ON : gosub WRITEVALUE
    lcd_param = DOPPELP  : gosub LCD_WRITECHAR
    pointer_eeprom = 4 : gosub set_index_eeprom : input# value 'Minute aus EEprom
    kein_komma = ON  : gosub WRITEVALUE
    gosub write_leerz
    lcd_param = ff_    : gosub LCD_WRITECHAR
    lcd_param = ue_    : gosub LCD_WRITECHAR
    lcd_param = rr_    : gosub LCD_WRITECHAR
    lcd_param = DOPPELP : gosub LCD_WRITECHAR
    pointer_eeprom = 5 : gosub set_index_eeprom : input# value 'Ein-Zeit aus EEprom
    kein_komma = ON : gosub WRITEVALUE
    if value <= 100 then gosub write_sec
    if value > 100 and value <= 200 then gosub write_min
    if value > 200 then gosub write_std
'    if value <= 100 then lcd_param = ss_
'    if value > 100 and value <= 200 then lcd_param = mm_
'    if value > 200 then lcd_param = hh_
    gosub LCD_WRITECHAR
    gosub write_leerz : gosub write_leerz : gosub write_leerz
    lcd_param=&B00001111 : gosub LCD_WRITECMD 'Cursor blinken ein
    if eingabe_teil_2 = off then lcd_param=&B11000000 else lcd_param=&B11000011 'Cursor auf best. Position
    if eingabe_teil_3 = on then lcd_param=&B11001010
    gosub LCD_WRITECMD
    return


#eing_4
if eingabe_teil_2 = on then goto fkt4_teil_2
if eingabe_teil_3 = on then goto fkt4_teil_3

'Eingabe Stunde
if keyb = 11 then goto end_fkt4 'Stunde
if stelle_1 = ON then goto fkt4_stelle2
pointer_eeprom = 3 : gosub set_index_eeprom :print# keyb 'Stunde
    stelle_1 = ON : goto display_fkt4 '1.Stelle
#fkt4_stelle2
pointer_eeprom = 3 : gosub set_index_eeprom : input# value
    value =  (10 * value ) + keyb
    gosub set_index_eeprom : print# value : goto display_fkt4
#end_fkt4
eingabe_teil_2 = on : stelle_1 = off : goto display_fkt4

'Eingabe Minute
#fkt4_teil_2
if keyb = 11 then goto end_fkt4_2
if stelle_1 = ON then goto fkt4_stelle2_2
pointer_eeprom = 4 : gosub set_index_eeprom :print# keyb 'Minute
    stelle_1 = ON : goto display_fkt4  '1.Stelle
#fkt4_stelle2_2
pointer_eeprom = 4 : gosub set_index_eeprom : input# value
    value =  (10 * value ) + keyb
    gosub set_index_eeprom : print# value : goto display_fkt4
#end_fkt4_2
eingabe_teil_2 = off : eingabe_teil_3 = on : stelle_1 = off : goto display_fkt4

'Eingabe Dauer
#fkt4_teil_3
if keyb = 11 then goto end_fkt4_3
if stelle_1 = ON then goto fkt4_stelle2_3
pointer_eeprom = 5 : gosub set_index_eeprom :print# keyb 'Dauer
    stelle_1 = ON : goto display_fkt4 '1.Stelle
#fkt4_stelle2_3
pointer_eeprom = 5 : gosub set_index_eeprom : input# value
    value =  (10 * value ) + keyb
    gosub set_index_eeprom : print# value : goto display_fkt4
#end_fkt4_3
eingabe_teil_3 = off : stelle_1 = off : goto display_fkt4

'Telefonnummer Eingabe
#key5
if keyb <> 5 then goto key6 'Anzeige nur Status Ausgnge
return
'fkt5 = ON : gosub del_lcd
'stelle_1 = off
'gosub write_Telefon_Nr
'#display_fkt5
'goto display_nr
'return

'#eing_5
'if stelle_1 = on then goto f1_1 'bei der ersten Eingabe alles lschen
'stelle_1 = on
'pointer_eeprom = 8 'ab hier Telefonnummer im EEprom
'gosub set_index_eeprom
'value = 11 'alles erst mal lschen mit Code "#"
'for lcd_param = 1 to 16
'print# value
'pointer_eeprom = pointer_eeprom + 1
'next lcd_param
'pointer_eeprom = 8
'#f1_1
'if keyb = 11 then return
'gosub set_index_eeprom : print# keyb 'Nummer speichern
'pointer_eeprom = pointer_eeprom + 1
'goto display_nr 'Anzeige

'Telefonnummer Test
#key6
if keyb <> 6 then goto key7
return
'fkt6 = on : gosub del_lcd 'Display loeschen
'#display_fkt6
'goto anrufen

'#eing_6
'return

'Eingabe Uhrzeit und Kanalanzahl
#key7
if keyb <> 7 then goto key8                  '
fkt7 = ON : gosub del_lcd 'Display lschen
#display_fkt7
    lcd_param = 1 : gosub LCD_GOTOLINE           '2.Zeile anw.
    gosub write_time
    lcd_param = Doppelp : gosub LCD_WRITECHAR
    value = hour  : kein_komma = ON : gosub WRITEVALUE  'Anzeige Uhrzeit Stunde
    lcd_param = DOPPELP : gosub LCD_WRITECHAR
    value = minute : kein_komma = ON : gosub WRITEVALUE 'Minute
    gosub write_leerz : gosub write_leerz
'    lcd_param = 2 : gosub LCD_GOTOLINE           '2.Zeile anw.
'    gosub write_solar
'    lcd_param = Strich    : gosub LCD_WRITECHAR
'    lcd_param = K_    : gosub LCD_WRITECHAR
'    lcd_param = aa_    : gosub LCD_WRITECHAR
'    lcd_param = nn_    : gosub LCD_WRITECHAR
'    lcd_param = ae_    : gosub LCD_WRITECHAR
'    lcd_param = ll_    : gosub LCD_WRITECHAR
'    lcd_param = ee_    : gosub LCD_WRITECHAR
'    lcd_param = DOPPELP : gosub LCD_WRITECHAR
'    open# for read : input# value : input# value : close# : kein_komma = on : gosub WRITEVALUE 	'Kanal-Nr aus EEprom
    lcd_param=&B00001111 : gosub LCD_WRITECMD 'Cursor blinken ein
    if eingabe_teil_2 = off then lcd_param=&B10000101 else lcd_param=&B10001000 'Cursor auf best. Position
'    if eingabe_teil_3 = on then lcd_param=&B11000111
    gosub LCD_WRITECMD
return

'Eingabe Zeit
#eing_7
if eingabe_teil_2 = on then goto eing_teil_2
'if eingabe_teil_3 = on then goto eing_teil_3

'Eingabe Stunde
if keyb = 11 then goto h01  'Zeichen #?
    value = (10 * hour ) + keyb 'Stunde
    if stelle_1 <> on or value <= 23 then goto wert_fkt7_ok
    gosub write_nein : stelle_1 = off : goto display_fkt7
#wert_fkt7_ok
if stelle_1 = off then hour = keyb else hour = (10 * hour ) + keyb
stelle_1 = on : goto display_fkt7
#h01
stelle_1 = OFF : eingabe_teil_2 = on : goto display_fkt7

'Eingabe Minute
#eing_teil_2
if keyb = 11 then goto end_inp_time 	'keine neue Eingabe?
if stelle_1 = off then minute = keyb else minute = (10 * minute ) + keyb
stelle_1 = on  : goto display_fkt7
#end_inp_time
stelle_1 = OFF : eingabe_teil_2 = off :eingabe_teil_3 = on : goto display_fkt7

'Eingabe Kanal-Anzahl
'#eing_teil_3
'if keyb = 11 then goto end_kanal	'keine neue Eingabe?
'if keyb >= 1 and keyb <= 4 then goto wert_fkt7b_ok
'gosub write_nein :  goto display_fkt7
'#wert_fkt7b_ok
'if keyb < 1 or keyb > 4 then goto display_fkt7
'pointer_eeprom = 2 : gosub set_index_eeprom : print# keyb : goto display_fkt7
'#end_kanal
'stelle_1 = OFF : eingabe_teil_3 = off : goto display_fkt7

'Umax, Umin-Anzeige + Eingabe
#key8
if keyb <> 8 then goto key9
return
fkt8 = on  : gosub del_lcd 'Display lschen
#display_fkt8
    lcd_param = 1 : gosub LCD_GOTOLINE           '2.Zeile anw.
'value = ((sensor_temp * 5)-365)/10 :kein_komma = on: gosub WRITEVALUE
return

#eing_8
if eingabe_teil_2 = on then goto fkt8_teil2
'Min-Spg
if keyb = 11 then goto end_fkt8
if stelle_1 = ON then goto fkt8_stelle2
pointer_eeprom = 21 : gosub set_index_eeprom :print# keyb
    stelle_1 = ON : goto display_fkt8  '1.Stelle
#fkt8_stelle2
pointer_eeprom = 21 : gosub set_index_eeprom : input# value
    value =  (10 * value ) + keyb
'if value < 100 then goto write_nein
    gosub set_index_eeprom : print# value : goto display_fkt8
#end_fkt8
eingabe_teil_2 = on : stelle_1 = off : goto display_fkt8

'Max-Spg
#fkt8_teil2
if keyb = 11 then goto end_fkt8b
if stelle_1 = ON then goto fkt8_stelle2b
pointer_eeprom = 22 : gosub set_index_eeprom :print# keyb
    stelle_1 = ON : goto display_fkt8  '1.Stelle
#fkt8_stelle2b
pointer_eeprom = 22 : gosub set_index_eeprom : input# value
    value =  (10 * value ) + keyb
'if value > 150 then goto write_nein
    gosub set_index_eeprom : print# value : goto display_fkt8
#end_fkt8b
eingabe_teil_2 = off : stelle_1 = off : goto display_fkt8

'Handebene
#key9
if keyb <> 9 then return
disp_fkt9 = on  : gosub del_lcd 'Display lschen

#Anzeige_Handebene
    lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile anw.
    lcd_param = B_    : gosub LCD_WRITECHAR 'Batterie
    lcd_param = aa_    : gosub LCD_WRITECHAR 'Solar pulsen
    lcd_param = S_    : gosub LCD_WRITECHAR
    lcd_param = oo_    : gosub LCD_WRITECHAR
    gosub write_leerz
    lcd_param = R_    : gosub LCD_WRITECHAR
    lcd_param = drei_    : gosub LCD_WRITECHAR
    lcd_param = R_    : gosub LCD_WRITECHAR
    lcd_param = vier_    : gosub LCD_WRITECHAR
    lcd_param = R_    : gosub LCD_WRITECHAR
    lcd_param = fuenf_    : gosub LCD_WRITECHAR
    lcd_param = R_    : gosub LCD_WRITECHAR
    lcd_param = sechs_    : gosub LCD_WRITECHAR
    gosub write_leerz
    lcd_param = R_    : gosub LCD_WRITECHAR
    lcd_param = sieben_    : gosub LCD_WRITECHAR

lcd_param = 2 : gosub LCD_GOTOLINE
lcd_param = eins_    : gosub LCD_WRITECHAR
if batt_ein = ON then lcd_param = A_ else lcd_param = pp_ : gosub LCD_WRITECHAR
lcd_param = zwei_    : gosub LCD_WRITECHAR
if solar_off = ON then lcd_param = pp_ else lcd_param = A_ : gosub LCD_WRITECHAR
gosub write_leerz

 lcd_param = drei_    : gosub LCD_WRITECHAR
 if relais_3 = ON then lcd_param = A_ else lcd_param = pp_  : gosub LCD_WRITECHAR
 lcd_param = vier_    : gosub LCD_WRITECHAR
 if pump = ON then lcd_param = A_ else lcd_param = pp_ : gosub LCD_WRITECHAR
 lcd_param = fuenf_    : gosub LCD_WRITECHAR
 if n_rechts = ON then lcd_param = A_ else lcd_param = pp_  : gosub LCD_WRITECHAR
 lcd_param = sechs_    : gosub LCD_WRITECHAR
 if n_links = ON then lcd_param = A_ else lcd_param = pp_ : gosub LCD_WRITECHAR
 gosub write_leerz
 lcd_param = sieben_    : gosub LCD_WRITECHAR
 if schaltuhr = ON then lcd_param = A_ else lcd_param = pp_  : gosub LCD_WRITECHAR
return

#eing_9
fkt9 = on
if keyb <> 1 then m_fkt_2
if batt_ein = off then batt_ein = on else batt_ein = off : goto Anzeige_Handebene

#m_fkt_2
if keyb <> 2 then goto m_fkt_3
if solar_off= off then solar_off= on else solar_off= off : goto Anzeige_Handebene

#m_fkt_3
if keyb <> 3 then goto m_fkt_4
if relais_3 = off then relais_3 = on else relais_3 = off : goto Anzeige_Handebene    'Pumpe ein

#m_fkt_4
if keyb <> 4 then goto m_fkt_5
if pump = off then pump = on else pump = off : goto Anzeige_Handebene    'Pumpe ein

#m_fkt_5
if keyb <> 5 then goto m_fkt_6
if n_rechts = off then n_rechts = on else n_rechts = off : goto Anzeige_Handebene

#m_fkt_6
if keyb <> 6 then goto m_fkt_7
if n_links = off then n_links = on else n_links = off : goto Anzeige_Handebene

#m_fkt_7
if keyb <> 7 then return
if schaltuhr = off then schaltuhr = on else schaltuhr = off : goto Anzeige_Handebene

#Reset 'mit Taste "*" zurck ins Grundmenu
'if fkt7 = off then goto reset_1
'Relais_3 = off : pump = off : n_rechts = off : n_links = off
'#reset_1
lcd_param=&B00001100 : gosub LCD_WRITECMD' Cursor blinken aus
gosub del_lcd
fkt1 = OFF : fkt2 = OFF : fkt3 = OFF : fkt4 = OFF
fkt5 = OFF : fkt6 = OFF : fkt7 = OFF : fkt8 = OFF : fkt9 = OFF : disp_fkt9 = off
stelle_1 = OFF  : eingabe_teil_2 = off : eingabe_teil_3 = off
meldung_aktiv = off : port1 = off : return  'Funktionen aus und Ende

'Anzeige Telefonnummer
'#display_nr
'tel_nr = on
'lcd_param = 2 : gosub LCD_GOTOLINE
'    pointer_eeprom = 8 : gosub set_index_eeprom  'Zeiger im EEprom
'    display_zaehler = 1
'#next_number
'    input# value
'    if value = 11 then goto end_display
'    kein_komma = on : gosub WRITEVALUE
'    display_zaehler = display_zaehler + 1
'    pointer_eeprom = pointer_eeprom + 1
'    if display_zaehler < 15 then goto next_number
'#end_display
'    for display_zaehler = 1 to 15
'    lcd_param = LEERZ : gosub LCD_WRITECHAR
'    next
'    tel_nr = off
'return

'#anrufen
'pointer_eeprom = 8 : gosub set_index_eeprom : input# value
'if value = 11 then return 'nicht anrufen wenn keine Nummer eingegeben
'lcd_param=&B00000001 : gosub LCD_WRITECMD
'gosub write_Anrufen
'gosub display_nr
'port_16 = on 'abheben
'pause 180 'etwas warten
'for pointer_eeprom = 8 to 19 'Zeiger Numer 1
'gosub set_index_eeprom : input# value 'Nummern lesen
'if value = 11 then goto end_call
'if value = 0 then value = 10 'wenn Nr = 0 dann 10 Pulse
'for display_zaehler = analog to value 'nur fr Fritz ISDN-Anlage
'port_16 = off : pause 3 : port_16 = on : pause 3  '62ms off; 38ms on
'next
'pause 40 '840 ms
'next
'#end_call
'fkt5 = off
'for value = 1 to 200 'Alarmmeldung durch Beep
'beep 800,25,10
'next
'port_16 = off 'auflegen und fertig
'return

' Kleine Hilfs Unterprogramme
#beep_kurz
port1= on : gosub output : pause 50 : port1= off : return

#beep_lang
port1= on : gosub output : return   'Beep groe Lautstrke

#pause
pause 60 : return

'Leerzeichen schreiben
#WRITE_LEERZ
lcd_param = LEERZ : gosub LCD_WRITECHAR : return


'Spannung Batterie umrechnen
#spannungs_wert
value =  121*(value-82)/144+77  'Y=12,1*(X-89)/144+7,7
return

'Umrechnung und Anzeige Temperatur-Wert
'#temp_value
'    value = (lcd_param * 5)-365:  gosub WRITEVALUE       'Temperatur Kochen
'    lcd_param = HOCHZ    : gosub LCD_WRITECHAR
'    lcd_param = C_    : gosub LCD_WRITECHAR
'    gosub WRITE_LEERZ : return

#write_batt
    lcd_param = B_    : gosub LCD_WRITECHAR
    lcd_param = aa_   : gosub LCD_WRITECHAR
    lcd_param = tt_   : gosub LCD_WRITECHAR : gosub LCD_WRITECHAR : return

#write_alarm
    lcd_param = A_    : gosub LCD_WRITECHAR
    lcd_param = ll_   : gosub LCD_WRITECHAR
    lcd_param = aa_   : gosub LCD_WRITECHAR
    lcd_param = rr_   : gosub LCD_WRITECHAR
    lcd_param = mm_   : gosub LCD_WRITECHAR : return
#write_time
     lcd_param = Z_    : gosub LCD_WRITECHAR
     lcd_param = ee_   : gosub LCD_WRITECHAR
     lcd_param = ii_   : gosub LCD_WRITECHAR
     lcd_param = tt_   : gosub LCD_WRITECHAR : return
#write_temp
     lcd_param = T_    : gosub LCD_WRITECHAR
     lcd_param = ee_   : gosub LCD_WRITECHAR
     lcd_param = mm_   : gosub LCD_WRITECHAR
     lcd_param = pp_   : gosub LCD_WRITECHAR : return
'#write_cooling
'     lcd_param = K_    : gosub LCD_WRITECHAR
'     lcd_param = ue_    : gosub LCD_WRITECHAR
'     lcd_param = hh_    : gosub LCD_WRITECHAR
'     lcd_param = ll_    : gosub LCD_WRITECHAR
'     Return
'#write_rotate
'     lcd_param = D_    : gosub LCD_WRITECHAR
'     lcd_param = rr_    : gosub LCD_WRITECHAR
'     lcd_param = ee_    : gosub LCD_WRITECHAR
'     lcd_param = hh_    : gosub LCD_WRITECHAR
'     lcd_param = ee_    : gosub LCD_WRITECHAR
'     lcd_param = nn_    : gosub LCD_WRITECHAR : Return
#write_on
     lcd_param = ee_ : gosub LCD_WRITECHAR
     lcd_param = ii_ : gosub LCD_WRITECHAR
     lcd_param = nn_ : gosub LCD_WRITECHAR : return
#write_off
     lcd_param = aa_ : gosub LCD_WRITECHAR
     lcd_param = uu_ : gosub LCD_WRITECHAR
     lcd_param = ss_ : gosub LCD_WRITECHAR  : return
#write_sec
    lcd_param = ss_  : gosub LCD_WRITECHAR
    lcd_param = ee_  : gosub LCD_WRITECHAR
    lcd_param = cc_  : gosub LCD_WRITECHAR  : write_leerz :return
#write_min
    lcd_param = mm_  : gosub LCD_WRITECHAR
    lcd_param = ii_  : gosub LCD_WRITECHAR
    lcd_param = nn_  : gosub LCD_WRITECHAR : write_leerz : return
#write_std
    lcd_param = S_  : gosub LCD_WRITECHAR
    lcd_param = tt_  : gosub LCD_WRITECHAR
    lcd_param = dd_  : gosub LCD_WRITECHAR : write_leerz : return

'#write_water
'    lcd_param = W_  : gosub LCD_WRITECHAR
'    lcd_param = aa_ : gosub LCD_WRITECHAR
'    lcd_param = ss_ : gosub LCD_WRITECHAR : gosub LCD_WRITECHAR
'    lcd_param = ee_ : gosub LCD_WRITECHAR
'    lcd_param = rr_ : gosub LCD_WRITECHAR : return

#write_nein
  lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile anw.
  lcd_param = N_    : gosub LCD_WRITECHAR
  gosub write_on
'  lcd_param = ee_    : gosub LCD_WRITECHAR
'  lcd_param = ii_    : gosub LCD_WRITECHAR
'  lcd_param = nn_    : gosub LCD_WRITECHAR
  lcd_param = Ausr    : gosub LCD_WRITECHAR: gosub write_leerz : gosub pause : return


#del_lcd
lcd_param=&B00000001 : gosub LCD_WRITECMD : return

'Zeiger im Flash-Eprom setzen
#set_index_eeprom
sys &h93 &h819d,&hB7CB,&hB692,&hB7CA,&hB691,pointer_eeprom + pointer_eeprom - 2 : return 'Zeiger 0; 2; 4; 6 etc

'*** LCD_Initialisierung ***
#LCD_INIT
  lcd_e=0        'Instruction-Mode
  gosub pause 'fr Hochlauf
  lcd_port = OFF ' alle ports auf 0
  lcd_port=&B00000010 : lcd_e=1 : lcd_e=0 'mit 8-Bit-Command in 4-Bit-Modus umschalten
  lcd_param=&B00101100 : gosub LCD_WRITECMD' Zeilen und Font einstellen
  lcd_param=&B00001100 : gosub LCD_WRITECMD'Display an
  lcd_param=&B00000001 : gosub LCD_WRITECMD'Display lschen
  lcd_port= &B00000110 : gosub LCD_WRITECMD 'Auto inkrement

  lcd_param = C_    : gosub LCD_WRITECHAR
  lcd_param = aa_    : gosub LCD_WRITECHAR
  lcd_param = rr_    : gosub LCD_WRITECHAR
  lcd_param = pp_    : gosub LCD_WRITECHAR
  lcd_param = ee_    : gosub LCD_WRITECHAR
   gosub write_leerz
  lcd_param = D_    : gosub LCD_WRITECHAR
  lcd_param = ii_    : gosub LCD_WRITECHAR
  lcd_param = ee_    : gosub LCD_WRITECHAR
  lcd_param = mm_    : gosub LCD_WRITECHAR
  lcd_param = &H21    : gosub LCD_WRITECHAR '!
  lcd_param = 2 : gosub LCD_GOTOLINE      '2.Zeile anw.
  lcd_param = V_    : gosub LCD_WRITECHAR 'Versions-Kennung
  gosub WRITE_LEERZ
  lcd_param = eins_ : gosub LCD_WRITECHAR : gosub pause : return

'LCD-Programme
#WRITEVALUE
if abs(value) >= 1000 then lcd_param = NULL + ((value mod 10000)/1000) else goto w01 ' Tausender-Dezimalstelle
gosub LCD_WRITECHAR
#w01
if abs(value) >= 100 then lcd_param = NULL + ((value mod 1000)/100) else goto  w02 ' Hunderter-Dezimalstelle
gosub LCD_WRITECHAR
#w02
if tel_nr = on then goto eine_ziffer
if abs(value) >= 10 then lcd_param = NULL + ((value mod 100)/10) else lcd_param = null ' Zehner-Dezimalstelle mit einer fhrenden 0
gosub LCD_WRITECHAR
goto w03
#eine_ziffer
if abs(value) >= 10 then lcd_param = NULL + ((value mod 100)/10) else goto w03 ' Zehner-Dezimalstelle ohne eine fhrenden 0 fr Tel-Nr
gosub LCD_WRITECHAR
#w03
if kein_komma = ON then goto w001
lcd_param = punkt :gosub lcd_writechar

#w001
kein_komma = OFF
lcd_param = NULL + value mod 10 ' einer Dezimalstelle ohne Leerzeichen
gosub LCD_WRITECHAR
return

' Zeilenwechsel
#LCD_GOTOLINE
if lcd_param = 1 then lcd_param = &H80 : if lcd_param = 2 then lcd_param = &HC0 'Code fr Zeile
goto LCD_WRITECMD

' LCD-Kommando
#LCD_WRITECMD
  lcd_rs=0 : goto LCD_WRITE

' Zeichenausgabe
#LCD_WRITECHAR
  lcd_rs=1

' Kommando oder Zeichen an Display senden
#LCD_WRITE
  lcd_port = lcd_param shr 4  :  lcd_e = 1 : lcd_e = 0 ' Hi-Nibble
  lcd_port = lcd_param and &H0F : lcd_e = 1 : lcd_e = 0 ' Lo-Nibble
  port1 = off 'da eventuell gesetzt
return

'Eingnge lesen
#eingaenge
'port12 = on : deact port1 : deact port2 : deact port3 'Vorbereiten Eingnge lesen
'if port1 = on then grundpos = on else grundpos = off 'fr Verfahren
'if port2 = on then leermeldung = on else leermeldung = off 'wenn mit Leermeldesensor
'if port3 = on then tuerschalter = on else tuerschalter = off 'fr Alarm
'port12 = off : clock1 = off :
return

'Ausgnge rausgeben
#output
port2 = schaltuhr 'Relais 7
port3 = batt_ein 'Relais Batt leer
if solar_off = off then port4 =on else port4 = off 'Relais 2
port5 = Relais_3 'Relais 3
port6 = pump 'Relais 4
port7 = n_rechts 'Relais 5
port8 = n_links 'Relais 6
pulse clock1 'bergabe an HV573
return
