'**********************************
' Solarkocher-Steuerung
'**********************************
'Bedienungen:
'1=Pasteurisieren; 2= Kochen; 3= Zeit Pumpe ein; 4= Spannung; 5= Handebene; 6= Nachfhrung; 7=Uhr; 8=Schaltuhr; 9=Status Ausgnge
'Grundmenu 0 = Alarmmeldung quit, Alarm-Hupe aus, Zeit_ga reset;
'kein Pumpen: eingabe von 0 min fr Pumpzeit max
'immer Pumpen: eingabe von 255 fr Pumpzeit max (immer ein!) oder Wert dazwischen
''keine Schaltuhr: eingabe von 0 min fr Pumpzeit max
'immer ein: eingabe von 255 fr Pumpzeit max (immer ein!) oder Wert dazwischen
'Beep: kochtemp., Schaltuhr, Alarmanlage, Tastendruck
'Reset Kochzeit: 0 im Grundmenu eingeben;
'Reset Alarm: 0 im Grundmenu eingeben
'Trockner: Meldung wenn Temp auerhalb der Grenzwerte
'Mit Leermeldung: Anschluss an Sensor 3; dann Pumpe aus
'Solarzelle etc khlen: Temp-Sensor an Sensor 4; Cooling on Aktivieren
'Solarzelle khlen und Alarm Deckel geht nicht gleichzeitig
'Wenn dryer_on = on und sensor_3 > grenz_temp_solar und minute mod 5 = 0 und second <= 5 dann pumpe = on
'Alarm Deckel: Wenn Sensor an 4 best. Wert unterschreitet; Funktion wird in einem best. Menu aktiviert
'Alarm kein Wasser bei Solar-Betrieb wenn Zeitlang Pumpe ein und Temperatur nicht niedriger dann Alarm
'Wenn "nur Kochen" angewhlt ist, so kann ber die FKT1 eine Zeit eingegeben werden. Nach erreichen der Temperatur und
'Ablauf der Zeit erfolgt eine Meldung
'Wird der Schalter kurz auf Verfahren gesetzt, so wird die Zeit auf 11 Uhr gesetzt, wenn nicht vorher eine Zeit eingegeben wurde
'Das Verfahren wird damit gestartet
'Einmal im Monat Batterien Gasungsspannung

'Daten in EEPROM:
'1 = Zeit insg. verfahren
'2 = Koch/Trockner-temperatur
'3 = Flanke Leermeldungsalarm
'4 = Schaltuhr Stunde
'5 = Schaltuhr Minute

'*** Festwerte ***
define time_past_pu_on_max 10  'Zeit Pumpe ein beim Past bis durch kompletten Schlauch
define temp_hyst 2 'Temperatur-Hysterese Tauchsieder ein/aus

define zeit_start_verf 10 'Stunde ab der Verfahren wird
define zeit_rueckfahren 18 'Stunde fr das Rckfahren
define nachf_voreinstellg_in_s 120 'Voreinstellung Zeit insgesamt verfahren in Sek Voreinst.
define verfahren_alle_ 30 'alle 30 min Verfahren
define Schlupfwert 30 'Schlupf-Wert beim Verfahren wegen Start/Stop

'Solar khlen
define kuehlen_alle_x_min 5 'Takt fr Pumpe ein
define kuehlen_zeit_pumpe_ein 5 'in Sekunden
define kuehltemp 0 'Direkte Eingabe (als Rohwert) oder Vorgabe ber Menu 1
define alarm_zaehler_kein_wasser_pumpe 3 'Anzahl Zyklen bis Alarm automatischer Trockenlaufschutz
define alarm_zaehler_kein_wasser_tauchs 5 'Anzahl Minuten bis Alarm automatischer Trockenlaufschutz

define grad_62 196

' define temp_puls_pasteur 162
' define temp_puls_kochen 196

'Tabelle 1
'define grad_65 200
'define time_65 30 'in Minuten mit 160 Pasteurisierungs-Units
'define grad_67 207
'define time_67 15 'in Minuten
'define grad_69 211
'define time_69 8 'in Minuten
'define grad_71 215
'define time_71 4 'in Minuten
'define grad_73 219
'define time_73 129 'in Sekunden
'define grad_75 223
'define time_75 66 'in Sekunden
'define grad_77 226
'define time_77 34 'in Sekunden
'define grad_79 231
'define time_79 17 'in Sekunden
'define grad_81 235
'define time_81 9 'in Sekunden

'Tabelle 2
define grad_65 200
define time_65 45 'in Minuten mit 160 Pasteurisierungs-Units
define grad_67 207
define time_67 22 'in Minuten
define grad_69 211
define time_69 12 'in Minuten
define grad_71 215
define time_71 6 'in Minuten
define grad_73 219
define time_73 193 'in Sekunden
define grad_75 223
define time_75 99 'in Sekunden
define grad_77 226
define time_77 47 'in Sekunden
define grad_79 231
define time_79 25 'in Sekunden
define grad_81 235
define time_81 15 'in Sekunden

define volt_10 115	'Batterie ist leer
define volt_10_5 122	'Meldung Batterie ist bald leer
define volt_11 130	'Batterie war leer
define volt_13 150	'Batterie war voll
define volt_14 170	'Batterie ist voll
define alarm_solar_voltage 49 'Wert ohne Paneel

' *** Port-Definition ***
define lcd_port byteport[1]
define hupe_ein port[1]	'Hupe laut
define relais_7 port[2] 'Khler fr die Solarzelle
define a_batt_ein port[3]    'Batterie aus
define relais_2 port[4]    'Solar aus
define relais_3 port[5]
define relais_4 port[6] 'Trockner
define relais_5 port[7] 'Verfahr-Motor
define relais_6 port[8] 'Schaltuhr oder Tauchsieder
define lcd_rs port[9]
define lcd_rw port[10]
define port11 port[11]
define port12 port[12]
define a_keyb port[13] 'Tastatur
define lcd_e port[14]
define clock1 port[15]  'LS374 Datenbergabe
define waehlen port[16]  'Whlvorrichtung

define u_batt AD[1]    '12 Volt
define u_ausg AD[2]    'Output voltage
define mess_pa AD[3]    'Temp Past.
define mess_ko AD[4]    'Temp Cooking
define Sensor_3 AD[5]   'Empty-Level oder Temperatur Solar
define Sensor_4 AD[6]   'Deckel-Sicherung
define Sensor_Solar AD[7] 'Solarzelle Diebstahlschutz
define wahlschalter AD[8]

' *** Bits-Definition ***
'define save_eeprom_flags byte[1]    'Bits 1-8 ->EEprom
define dryer_on bit[1] '
define position_ein bit[2]   'Freigabe vom Anwender
define solar_off bit[3]  'Relais Batterie voll
define kuehlen bit[4]   'Umschaltung Zeitgeber Nachfhrung in sec
define disp_batt bit[5]     'Anzeige Batteriespannung
define disp_time bit[6]     'Anzeige Zeit
define flanke_alarm_solar  bit[7] '
define alarm_deckel bit[8] '
define fkt_past bit[9]   'Funktion Pasteuer
define fkt_water_cook bit[10]   'Funktion Kochen
define fkt1 bit[11]   'Funktion Kochzeit
define FKT4 bit[12]   'Funktion Spannungsanzeige
define fkt5 bit[13]   'Funktion
define FKT6 bit[14]   'Funktion
define FKT7 bit[15]   'Funktion Uhreingabe
define FKT2 bit[16]   'Funktion Schaltuhr
define fkt9 bit[17]   'Funktion Handebene
define meldung_aktiv bit[18]   'Hupe aktiv
define flanke_alarm_batt bit[19]   'Flanke Batterie bald leer
define flanke_alarm_alarm bit[20]     'Alarm Diebstahlsicherung abschalten
define flanke_alarm_max_pumpen bit[21]   'Alarm Max-Zeit pumpen
define fkt3 bit[22]   'Funktion Count_down
define batt_ein bit[23] '
define solar_pulsen bit[24]     'Solar laden pulsen
define stelle_1 bit[25]
define pump bit[26]
define dryer bit[27]
define n_rechts bit[28]
define schaltuhr bit[29]
define flanke_ko bit[30]
define sec_zaehlen bit[31]       'Umschaltung Sekunden zhlen fr Pasteurisierung
define keyb_flanke bit[32]
define kein_komma bit[33]       'kein Komma!
define eingabe_teil_2 bit[34]   'Dateneingabe teil 2
define eingabe_teil_3 bit[35]   'Dateneingabe teil 3
define eingabe_teil_4 bit[36]   'Dateneingabe teil 3
define tauchsieder_ein bit[37]
define disp_fkt9 bit[38] 'Nur Anzeige Handebene
define Zeit_ueber_Tastur bit[39] '
define flanke_Leermeldesonde bit[40]
define flanke_kein_wasser_pumpe bit[41]
define flanke_kein_wasser_tauchs bit[42]
define korrektur_zeit bit[43]
'+ 4 bits frei!!

' *** Byte-Definition ***
define sec_alt byte[7]    'Second-counter Flanke
define time_pa byte[8]    'Zeit Pasteuer
define time_ko byte[9]    'Zeit Garen
define su_time byte[10]     'Schaltuhr Zeit ein gespeichert *sichern
define zaehler_kein_wasser byte[11]     'Schaltuhr Stunde *sichern
define time_past_pu_on byte[12]     'Time for Pump on *sichern
define nachf_time byte[13]     'Verfahren Zeitgeber
define alarm_temp_alt byte[14]     'Temperaturwert vor Pumpen
define ein_fuer byte[15]     'Eingabe Zeit Pumpe max ein *sichern
define old_voltage_Solar byte[16]          'Beep-Temperatur *sichern
define keyb byte[17]            'Input keyboard
define lcd_param byte[18]       'Daten an LCD
define temp_trocken_alt byte[19]  'Temperatur alt Tauchsieder alt
define su_time_act byte[20]     'Schaltuhr Zeit ein aktuell *sichern
define t_max_pu_ein byte[21]   'Max-Zeit Pumpe in Sekunden *sichern
define count_down byte[22]     'Rckwrtszhler
define value word[12]     'Schmier-Flag

define wert_pos_1  240 'Wahlschalter
define wert_pos_2  218 'Wahlschalter
define wert_pos_3  187 'Wahlschalter
define wert_pos_4  161 'Wahlschalter
define wert_pos_5  94 'Wahlschalter
define wert_pos_6  55 'Wahlschalter
define wert_pos_7  41 'Wahlschalter
define wert_pos_8  24 'Wahlschalter

'*** ASCII-Codes ***
define A_ &H41
define B_ &H42
define C_ &H43
define D_ &H44
define E_ &H45
define F_ &H46
define G_ &H47
define H_ &H48
define I_ &H49
define J_ &H4A
define K_ &H4B
define L_ &H4C
define M_ &H4D
define N_ &H4E
define O_ &H4F
define P_ &H50
define Q_ &H51
define R_ &H52
define S_ &H53
define T_ &H54
define U_ &H55
define V_ &H56
define W_ &H57
define X_ &H58
define Y_ &H59
define Z_ &H5A

define aa_ &H61
define ae_ &HE1
define bb_ &H62
define cc_ &H63
define dd_ &H64
define ee_ &H65
define ff_ &H66
define gg_ &H67
define hh_ &H68
define ii_ &H69
define jj_ &H6A
define kk_ &H6B
define ll_ &H6C
define mm_ &H6D
define nn_ &H6E
define oo_ &H6F
define oe_ &HEF
define pp_ &H70
define qq_ &H71
define rr_ &H72
define ss_ &H73
define tt_ &H74
define uu_ &H75
define ue_ &HF5
define vv_ &H76
define ww_ &H77
define xx_ &H78
define yy_ &H79
define zz_ &H7A

define null_ &H30
define eins_ &H31
define zwei_ &H32
define drei_ &H33
define vier_ &H34
define fuenf_ &H35
define sechs_ &H36
define sieben_ &H37
define acht_ &H38
define neun_ &H39

define LEERZ &H20
define MINUS &H2D
define NULL &H30
define GLEICH &H3D
define PUNKT &H2E
define HOCHZ &HDF
define DOPPELP &H3A
define Strich &H2D
define Ausr &H21 'Ausrufungszeichen
define fragez &H3F
define Prozent &H25
define schraegstrich &H2F

' *** Initialisierungen ***
batt_ein = on : gosub output       'Batterie erst mal ein
gosub LCD_INIT        'Initialisierungen
ein_fuer = 255 'Max-Zeit Pumpen auf "immer ein" setzen
old_voltage_Solar = Sensor_Solar 'Solar-berwachung
alarm_temp_alt = mess_pa '
temp_trocken_alt = mess_pa
open# for write : close# ' Initialisiere Datei ohne was zu schreiben
open# for read : input# value : input# lcd_param: close#	'Start-wert verfahren lesen
if value > 0 and value < 255 then goto init1	'Ist schon ein Wert fr Verfahrzeit eingegeben?
open# for write : print# nachf_voreinstellg_in_s : close#	'Voreinstellungswert verfahren
#init1
if lcd_param > 60 and lcd_param < 95 then goto loop 'Voreinstellung fr Kochtemp
lcd_param = 2: gosub set_index_eeprom : print# 76 'Kochtemp

' *** Zyklisches Programm ***
#loop
gosub Keyboard
gosub time_sec  'Zeitscheibe Sekunde
goto loop

'Zeitscheibe Sekunde
#time_sec
if second = sec_alt then return
sec_alt = second
if second = 59 then gosub time_min  'Zeitscheibe Minute
if minute mod 5 = 0 and second = 10 and korrektur_zeit = 0 then second = second - 1 'Korrektur Zeit alle zwei Minuten = 12 Min pro Tag
if minute mod 2 = 0 and second = 10 then korrektur_zeit = 1
if minute mod 2 = 0 and second = 1 then korrektur_zeit = 0

gosub wahlschalter
if wahlschalter < wert_pos_6 then goto aus 'Aus
if fkt9 = on then goto weit1 'Hand
gosub pasteur
gosub pump_on_ko 'erst bei Kochtemp pumpen
if fkt1 = off then gosub beep_kochen
gosub pulsen
gosub nachfuehrung
gosub Tauchsieder_schaltuhr
gosub drying
gosub solar_kuehlen
gosub wasser_alarm 'berwachung Wasserzufhrung
gosub Alarm_max_zeit_pumpen 'angegebene Pumpzeit abgelaufen
gosub batterie_voll 'Solar laden aus
#weit1
if (count_down = 1 or su_time_act = 1 ) and second >= 49 and second < 59 then gosub zeit_alarm 'Count-down Alarm oder Schaltuhr
if second = 59 and count_down > 0 then count_down = count_down - 1	'Countdown runterzhlen?
gosub Alarm_Cooker
gosub Alarm_Solar
gosub daueralarm
#aus
gosub output 'Ausgnge ansteuern

'if fkt1 = on then gosub disp_pump_max 'Eingabe Max-Zeit Pumpen
'if fkt2 = on then gosub display_timer 'Schaltuhr
'if fkt3 = on then gosub display_count_down
if fkt4 = on then gosub display_spannung
'if fkt5 = on then gosub display_dryer
'if fkt6 = on then gosub disp_nachf 'Anzeige Nachfhrung
'if fkt7 = on then gosub display_zeit 'Zeiteingabe
if disp_fkt9 = on and fkt9 = off then gosub Anzeige_Handebene 'Handebene nur Anzeige

if sec_zaehlen = on then time_pa = time_pa + 1 'Zeit Pasteurisierung in Sekunden?
if n_rechts = on then nachf_time = nachf_time + 1 'Verfahrzeit
if pump = off then time_past_pu_on = 0 'Past-Zeit Reset
if pump = on then time_past_pu_on = time_past_pu_on + 1 'Menge durch Wrmetauscher
if dryer_on = off and fkt9 = off and ein_fuer = 0 then pump = off  'Max-Zeit Pumpe abgelaufen?
if ein_fuer <= 0 or ein_fuer = 255 then goto ende       'max-Zeit Pumpe ein berwachen?
'bei reinem Tauchsieder-Betrieb (ohne Pumpe)
gosub kochtemp
if fkt_past = off and fkt_water_cook = off and mess_pa > value and second = 59 then ein_fuer = ein_fuer - 1
'Pump-Betrieb
if pump = on then t_max_pu_ein = t_max_pu_ein + 1  'Zeit max Pumpe ein Sekunden zhlen
if t_max_pu_ein < 60 then goto ende 'alle 60 Sekunden Eingabe-Wert dekr
ein_fuer = ein_fuer - 1 : t_max_pu_ein = 0 'Minutenzhler
#ende
goto Grundmenue       'Anzeige Display Grundfunktionen
Return

'Zeitscheibe Minute
#time_min
time_ko = time_ko + 1   'Zeit Kochen
if sec_zaehlen = off then time_pa = time_pa + 1  'Zeit Pasteur
if su_time <> 0 and su_time <> 255 and su_time_act > 0 then su_time_act = su_time_act - 1 'Schaltuhr
if n_rechts = off and position_ein = on then nachf_time = nachf_time + 1 'alle 30 min verfahren
gosub data_to_pc
gosub Alarm_batt_leer 'Alarmmeldung
gosub batterie_leer 'Spgs-geber, NiCd laden aus, Last-Relais aus
Return

#Wahlschalter
if wahlschalter < wert_pos_1 then goto a001
fkt_past = on : fkt_water_cook = off : tauchsieder_ein = off :return  'Pos 1 = Pasteuer ohne Tauchsieder
#a001
if wahlschalter < wert_pos_2 then goto a002
fkt_past = off : fkt_water_cook = on : tauchsieder_ein = off : return 'Pos 2 = Kochen ohne Tauchsieder
#a002
if wahlschalter < wert_pos_3 then goto a003
fkt_past = on : fkt_water_cook = off : tauchsieder_ein = on :return 'Pos 3 = Pasteuer mit Tauchsieder
#a003
if wahlschalter < wert_pos_4 then goto a004
fkt_past = off : fkt_water_cook = on : tauchsieder_ein = on : return 'Pos 4 = Kochwasser mit Tauchsieder
#a004
if wahlschalter < wert_pos_5 then goto a005
fkt_past = off : fkt_water_cook = off : tauchsieder_ein = on :return 'Pos 5 = nur mit Tauchsieder Kochen, keine Wasserprod.
#a005
if wahlschalter < wert_pos_6 then goto a006
position_ein = on : if Zeit_ueber_Tastur = on or hour = 11 then return 'Pos 6 = Positionieren ein und Start
hour = 11 : minute = 0 : return 'Start verfahren; Zeit auf 11 Uhr setzen
#a006
fkt_past = off : fkt_water_cook = off : tauchsieder_ein = off :return ''Pos 7 = Aus

#Grundmenue
if fkt1 = on or fkt2 = on or fkt3 = on or fkt4 = on or fkt5 = on or fkt6 = on or fkt7 = on or disp_fkt9 = on then return 'andere FKT angew?
if meldung_aktiv = on then goto line_2  'Meldung wird gerade angezeigt
    lcd_param = 1 : gosub LCD_GOTOLINE  '1.Zeile des Displays wird aktiviert
    gosub write_cook
    lcd_param = T_     : gosub LCD_WRITECHAR
    gosub write_leerz
    gosub write_time    'Auf dem Display erscheint: Temp Kochz Past/Koch
     gosub write_leerz
    if wahlschalter < wert_pos_6 then goto disp6
    if wahlschalter < wert_pos_5 then goto disp5
    if fkt_water_cook = on then goto disp1
    if fkt_past = off then goto disp4
    lcd_param = P_    : gosub LCD_WRITECHAR     'Funktion 1 = Pasteur
    lcd_param = aa_    : gosub LCD_WRITECHAR
    lcd_param = ss_    : gosub LCD_WRITECHAR
    lcd_param = tt_     : gosub LCD_WRITECHAR
    goto disp2
#disp1
    gosub write_hotW : goto disp2
#disp4
   gosub write_cook
#disp2
    if tauchsieder_ein = on then lcd_param = E_ else lcd_param = S_ 'Anzeige Solar oder Tauchsieder angew.
    gosub LCD_WRITECHAR : goto line_2
#disp5
   gosub write_rotate : goto line_2
#disp6
   gosub write_off : gosub write_leerz: gosub write_leerz: gosub write_leerz
#line_2
    lcd_param = 2       : gosub lcd_gotoline    '2.Zeile des Displays wird aktiviert
    lcd_param =  mess_ko
    gosub temp_value
    value = su_time_act:  kein_komma = ON : gosub WRITEVALUE
'    value = time_ko : kein_komma = ON : gosub WRITEVALUE        ' Kochzeit time_ko
    lcd_param = mm_    : gosub LCD_WRITECHAR
    gosub WRITE_LEERZ

    if disp_batt = on or disp_time = on then goto display4       'Anzeige Umschalten?
    lcd_param = mess_pa : gosub temp_value
#display4
    if disp_time = on then goto display5       'Anzeige Zeit?
    value = u_batt : gosub spannungswert : gosub WRITEVALUE       'Batteriespannung
    lcd_param = V_    : gosub LCD_WRITECHAR
    gosub WRITE_LEERZ  : return
    return
#display5
    value = hour : kein_komma = ON : gosub WRITEVALUE    'Anzeige Uhrzeit hour
    if second mod 2 <> 0 then lcd_param = Leerz else lcd_param = Doppelp
    gosub LCD_WRITECHAR
    value = minute : kein_komma = ON : gosub WRITEVALUE              'minute
    gosub WRITE_LEERZ  : return

'ab best Temp pulsen, damit keine Dampfblasenbildung //notwendig?
#pulsen
if dryer_on = on or second <> 0 or minute mod 2 <> 0 or pump = on or tauchsieder_ein = on then return 'alle 2 Minuten
if mess_pa < grad_79 or ein_fuer <> 0 then return 'ab best. Temp und wenn Pump-Funktion aus ist
gosub pump_on : pause 70 : pump = off     '//Zeit fr Pulsen
Return

'UP Pasteur
#pasteur
if fkt_past = off or mess_pa < 10 or dryer_on = on then return 'aus bei kochen, Handebene ein oder kein Sensor angeschlossen?
if su_time <> 0 and su_time_act = 0 then return 'Wenn Schaltuhr-Fkt aktiv erst ein wenn Zeit gestartet
if mess_pa < grad_62 or pump = on then time_pa = 0 'Temp < 62 Grad, dann Zeit Reset?
if mess_pa > grad_62 and time_past_pu_on < time_past_pu_on_max then goto vergl  'fertig wenn best. Temp unterschr. oder max-Durchfl-Zeit?
pump = off : return

#vergl
if mess_pa > grad_71 then sec_zaehlen = on else sec_zaehlen = off    'In Sekunden zhlen ab 71 Grad?
if sec_zaehlen = on then goto sec_zaehl
'if mess_pa > grad_62 and time_pa > time_62 then gosub pump_on  'Zeit in Minuten
if mess_pa > grad_65 and time_pa > time_65 then gosub pump_on
if mess_pa > grad_67 and time_pa > time_67 then gosub pump_on
if mess_pa > grad_69 and time_pa > time_69 then gosub pump_on
if mess_pa > grad_71 and time_pa > time_71 then gosub pump_on :return
#sec_zaehl
if mess_pa > grad_73 and time_pa > time_73 then gosub pump_on    'ab jetzt in Sekunden!
if mess_pa > grad_75 and time_pa > time_75 then gosub pump_on
if mess_pa > grad_77 and time_pa > time_77 then gosub pump_on
if mess_pa > grad_79 and time_pa > time_79 then gosub pump_on
if mess_pa > grad_81 and time_pa > time_81 then gosub pump_on :return

'Pumpe ein bei Koch-Temp
#pump_on_ko
if fkt_water_cook = off or fkt1 = on or mess_pa < 10 or dryer_on = on then return 'Funktion aus bei Past oder Handebene oder Sensor nicht angeschl?
if su_time = 0 or su_time_act <> 0 then goto pump_ko_01 'Wenn Schaltuhr-Fkt aktiv erst ein wenn Zeit gestartet
pump = off : Return
#pump_ko_01
gosub kochtemp 'eingegebene Kochtemperatur (bezogen auf mess_pa)
if mess_pa < value - 5 then pump = off    '// *** Hysterese-Wert Pumpe aus/ein
if mess_pa >= value then gosub pump_on : Return

'Beep bei Kochtemp oder Trockner auerhalb des Temp-Bereiches
#beep_kochen
gosub kochtemp 'eingegebene Kochtemperatur (bezogen auf mess_pa)
if dryer_on = off then goto cook_message
if fkt5 = on then return
'Trockner-Temp
if mess_ko > value - 5 and mess_ko < value + 5 then flanke_ko = off
if mess_ko > value + 10 then goto message_dry_temp '*** Alarm Trockner Temp auserhalb dem Bereich!
if mess_ko < value - 10 then goto message_dry_temp '*** Alarm Trockner Temp auserhalb dem Bereich!
return
#message_dry_temp
if flanke_ko = ON then return
lcd_param=&B00000001 : gosub LCD_WRITECMD
   gosub write_cooling
   goto message_temp

#cook_message
if tauchsieder_ein = off then lcd_param = mess_ko else lcd_param = mess_pa 'unterschiedliche Sensoren abfragen
if lcd_param < value then time_ko = 0 'Anzeige Kochzeit Reset wenn kleiner Kochtemp
if lcd_param < value - 10 then flanke_ko = OFF 'mit Hysterese-Wert 10
if lcd_param < value or flanke_ko = ON then return
'Meldung Kochtemperatur
    lcd_param=&B00000001 : gosub LCD_WRITECMD      '1.Zeile anw.
    gosub write_cook
#message_temp
    lcd_param = Strich    : gosub LCD_WRITECHAR     '5
    gosub write_temp
    lcd_param = Ausr    : gosub LCD_WRITECHAR     '16
meldung_aktiv = on : gosub beep_kurz : flanke_ko = ON : return

'Sonnennachfhrung
#nachfuehrung
if position_ein = off or (hour >= zeit_rueckfahren and hour < zeit_start_verf ) then goto verf_reset 'Funktion abgewhlt ab 19 Uhr ***
if n_rechts = on then goto verfahren 'wird gerade verfahren?
if nachf_time <= verfahren_alle_ then return 'alle xx min Verfahren! ***
nachf_time = 0  'Zeitgeber Verfahren in Sekunden aktiv

#verfahren
open# for read : input# value : close#	'Verfahrzeit aus EEprom lesen
value = (value + Schlupfwert )/ 14 '//je nachdem wieviele Zeitabschnitte von 11 bis 18 Uhr liegen + Schlupf von 30 wegen anfahren ***
if nachf_time < value then goto verf_an  'Verfahrinkrement (Gesamtzeit in sec / Anzahl halbe Std) abgelaufen?
n_rechts = off : nachf_time = 0 : return
#verf_an
n_rechts = on : return

#verf_reset
nachf_time = 0 : n_rechts = off : position_ein = off :  return

'Tauchsieder
#Tauchsieder_schaltuhr
if fkt1 = on or fkt2 = on then return        'Dateneingabe?
if su_time <> 255 then goto su01 'immer ein von Schaltuhr?
schaltuhr = on : return 'Gert immer ein
#su01
if su_time <> 0 or tauchsieder_ein = on then goto su_ein 'Funktion aus bei Eingabe 0 und Tauchsieder aus?
schaltuhr = off  : return 'Ausschalten
#su_ein
if tauchsieder_ein = off and su_time_act <> 0 then goto schaltuhr_ein 'Als reine Schaltuhr eingestellt; ***Riskant!
if su_time <> 0 and su_time_act = 0 then goto schaltuhr_aus 'Aus von Schaltuhr wenn Wert eingegeben?

gosub kochtemp '//Kochtemp bezogen auf mess_pa
if tauchsieder_ein = off or dryer_on = on then goto einschaltzeit
if (fkt_water_cook = on or fkt_past = on ) and mess_pa < value - temp_hyst and ein_fuer <> 0 then goto schaltuhr_ein '***Hysterese Tauchsieder ein wenn unter Kochtemperatur
if fkt_past = off and fkt_water_cook = off and mess_ko < value - temp_hyst then goto schaltuhr_ein 'wenn nur kochen; Kocher-Sensor

if fkt_past = on and ein_fuer = 0 then goto schaltuhr_aus 'Tauchsieder aus wenn Pasteur aktiv und best.Menge erreicht
if (fkt_water_cook = on or fkt_past = on ) and mess_pa > value then goto schaltuhr_aus
if fkt_past = off and fkt_water_cook = off and mess_ko > value  then goto schaltuhr_aus 'Kocher-Sensor!
goto einschaltzeit '// Tauchsieder aus wenn Kochtemp - Hysterese

#schaltuhr_ein
schaltuhr = on : goto einschaltzeit
#schaltuhr_aus
schaltuhr = off

'Zeit-Schaltuhr aktivieren
#einschaltzeit
lcd_param = 4 : gosub set_index_eeprom : input# value 'Schaltuhr Stunde
lcd_param = 5 : gosub set_index_eeprom : input# keyb 'Minute
if hour <> value or minute <> keyb or second > 10 or su_time = 0 then return 'or su_alle_x_min <> 0 or mess_feuchte > feuchte_grenzwert Uhrzeit erreicht und aktiv?
su_time_act = su_time           'Einschaltzeit aktivieren
return

'Fan for Drying
#Drying
if dryer_on = off or mess_ko < value then dryer = off  '// Dryer off
if fkt1 = on or dryer_on = off then return  'Dateneingabe Temperatur?
gosub kochtemp '//Kochtemp bezogen auf mess_ko
if mess_ko > value + 5 then dryer = on  'Dryer on
return

#Solar_kuehlen
if alarm_deckel = on or kuehlen = off then return 'Da Alarm-Sensor gleichen AE benutzt!
if kuehltemp <> 0 then value = kuehltemp else gosub kochtemp '//feste Eingabe oder ber Menu 1
if sensor_4 > value and minute mod kuehlen_alle_x_min = 0 and second <= kuehlen_zeit_pumpe_ein then pump = on '*** alle 5 Minuten 5 Sek lang
if minute mod kuehlen_alle_x_min <> 0 or second > kuehlen_zeit_pumpe_ein or sensor_4 < value -5 then pump = off 'alle 5 minn fr 4 Sek
return

'Alarm Batterie bald leer
#Alarm_batt_leer
if u_batt < 10 then return 'keine Batterie angeschlossen
if u_batt < volt_10_5 then goto alarm_batt 'Vorwarnung Batt leer
if u_batt > volt_10_5 + 20 then flanke_alarm_batt = off : return 'Flanke Reset mit Hysterese
#alarm_batt
if flanke_alarm_batt = on or meldung_aktiv = on then return	'nur einmal anstossen oder keine Batt angeschl
lcd_param=&B00000001 : gosub LCD_WRITECMD 'Display lschen
    lcd_param = B_    : gosub LCD_WRITECHAR     '1
    lcd_param = aa_    : gosub LCD_WRITECHAR     '2
    lcd_param = tt_    : gosub LCD_WRITECHAR : gosub LCD_WRITECHAR     '3
    lcd_param = ee_    : gosub LCD_WRITECHAR     '12
    lcd_param = rr_    : gosub LCD_WRITECHAR     '13
    lcd_param = yy_    : gosub LCD_WRITECHAR     '14
    lcd_param = Ausr    : gosub LCD_WRITECHAR     '14
    gosub write_leerz : gosub write_leerz
'    gosub write_alarm
meldung_aktiv = on : flanke_alarm_batt = on : gosub beep_kurz: gosub pause:  return

'UP Batterie leer, Batt-Entnahme aus
#batterie_leer
if u_batt < volt_11 then goto b02 'Batt wieder ein?
batt_ein = on  : return
#b02
if u_batt < volt_10 then batt_ein = off 'Batterie leer
if batt_ein = on then return
pump = off : n_rechts = off : dryer = off : schaltuhr = off : return 'Batterie ist leer, alles aus //

'UP Batterie voll, Solar aus
#batterie_voll
'if Sensor_Solar < 60 then goto reset_solar 'keine Solarzelle angeschl.
if u_batt < volt_14 or second < 55 then goto batt_voll_1 'Batterie voll und verzgert?
solar_off = on : solar_pulsen = on : return 'kein laden mehr; Pulsen aktivieren
#batt_voll_1
if u_batt > volt_13 then goto solar_pulsen 'Solar wieder ein?
#reset_solar
solar_off = off : solar_pulsen = off : return 'laden wieder ein!

#solar_pulsen
if solar_pulsen = on and second > 50 then solar_off = off	'laden pulsen fr // 10 Sek.
if solar_pulsen = on and second <= 50 then solar_off = on	'laden pulsen
return

'Alarm von Sensor oder Kocher-Deckel
#Alarm_cooker
if ((alarm_deckel = on and fkt3 = off and sensor_4 < 100) or mess_pa < 30 ) then goto alarm1 'Alarm von Deckel oder Sensor mess_pa
flanke_alarm_alarm = off : return	'Flanke + Hupe Reset ***hupe_ein= off :
#alarm1
if flanke_alarm_alarm = on or meldung_aktiv = on then return	'nur einmal anstossen
lcd_param=&B00000001 : gosub LCD_WRITECMD 'Display lschen
    gosub write_alarm : gosub WRITE_LEERZ
    gosub write_cook
    lcd_param = ee_    : gosub LCD_WRITECHAR     '12
    lcd_param = rr_    : gosub LCD_WRITECHAR     '16
meldung_aktiv = on : flanke_alarm_alarm = on : return

'Wenn die Solar-Spannung sich erst sehr stark gendert hat und sie dann einen bestimmten Wert hat
#Alarm_solar
'if hour = 0 and minute = 0 and second < 30 then return 'nicht beim einschalten gleich Alarm
if second mod 4 <> 0 then return 'alle 4 Sekunden
if Sensor_Solar > old_voltage_Solar + 5 or Sensor_Solar < old_voltage_Solar - 5 then goto next_check else goto next_10 'Spannungsnderung zu gro?
#next_check
lcd_param=&B00000001 : gosub LCD_WRITECMD 'Display lschen
gosub write_alarm : gosub write_leerz : gosub write_solar
gosub beep_kurz : meldung_aktiv = on
if Sensor_Solar < alarm_solar_voltage + 3 and Sensor_Solar > alarm_solar_voltage - 3 then goto alarm_solar_ein else goto next_10 'Alarmspannung liegt an?

#alarm_solar_ein
if flanke_alarm_solar = on or meldung_aktiv = on then return
lcd_param=&B00000001 : gosub LCD_WRITECMD 'Display lschen
   gosub write_alarm : gosub write_leerz : gosub write_solar
meldung_aktiv = on : flanke_alarm_solar = on
old_voltage_Solar = Sensor_Solar : return
#next_10
old_voltage_Solar = Sensor_Solar
flanke_alarm_solar = off
return

'Alarm kein Wasser bei Solar-Betrieb
'wenn Zeitlang Pumpe ein und Temperatur nicht niedriger dann Alarm
#wasser_alarm
'if (pump = on and time_past_pu_on > 9 and mess_pa > alarm_temp_alt) or (tauchsieder_ein = on and schaltuhr = on and second = 30 and mess_pa > temp_trocken_alt) then goto reset_alarm_wasser else goto Leermeldesonde
'#reset_alarm_wasser
'flanke_kein_wasser = off : zaehler_kein_wasser = 0

#Leermeldesonde
if sensor_3 > 200 and dryer = off then goto meldung_wasser 'Leermelde-Sensor
flanke_Leermeldesonde = off

#pumpe_ein
if tauchsieder_ein = on then goto Tauchsieder
if pump = off then alarm_temp_alt = mess_pa
'if pump = off then zaehler_kein_wasser = 0
if time_past_pu_on < 5 or pump = on then return 'erst wenn Pumpe mind 9 Sek an
if mess_pa <= alarm_temp_alt then goto alarm_pumpe 'hat sich die Temp um best. Wert verringert?
flanke_kein_wasser_pumpe = off :zaehler_kein_wasser = 0 : return
#alarm_pumpe
zaehler_kein_wasser = zaehler_kein_wasser + 1
if zaehler_kein_wasser > alarm_zaehler_kein_wasser_pumpe then goto meldung_wasser
return

'Alarm kein Wasser bei Tauchsieder-Betrieb
'wenn Tauchsieder ein und Temp < 65 Grad dann muss nach best. Zeit Temp. mess_pa hher sein
#Tauchsieder
if schaltuhr = off then goto value_load 'Start-Wert berwachung
if second >< 30 then return 'alle Minute
#check_temp
if mess_pa <= temp_trocken_alt then goto alarm_tauchs
flanke_kein_wasser_tauchs = off : zaehler_kein_wasser = 0 :return
#alarm_tauchs
zaehler_kein_wasser = zaehler_kein_wasser + 1
if zaehler_kein_wasser > alarm_zaehler_kein_wasser_tauchs then goto meldung_wasser
#value_load
temp_trocken_alt = mess_pa : return

#meldung_wasser
if meldung_aktiv = on or flanke_Leermeldesonde = on or flanke_kein_wasser_pumpe = on or flanke_kein_wasser_tauchs = on then return  'nur einmal anstossen
lcd_param=&B00000001 : gosub LCD_WRITECMD 'Zeile lschen
'pump = off : tauchsieder_ein = off 'Pumpe, Tauchsieder ausschalten
    gosub write_water
    lcd_param = fragez    : gosub LCD_WRITECHAR     '13
    gosub LCD_WRITECHAR     '14
if sensor_3 > 200 then flanke_Leermeldesonde = on
if pump = on then flanke_kein_wasser_pumpe = on
if schaltuhr = on then flanke_kein_wasser_tauchs = on
meldung_aktiv = on : gosub beep_kurz : gosub pause : return

#zeit_alarm
gosub beep_kurz		'Zeit abgelaufen
    lcd_param=&B00000001 : gosub LCD_WRITECMD 'Display lschen
    gosub write_time
    lcd_param = strich    : gosub LCD_WRITECHAR  '6
    gosub write_alarm
    lcd_param = Ausr    : gosub LCD_WRITECHAR     '15
meldung_aktiv = on  :return

#Alarm_max_zeit_pumpen
if ein_fuer = 0 and flanke_alarm_max_pumpen = off then goto alarm_max_zeit 'Vorwarnung Batt leer
if ein_fuer <> 0 then flanke_alarm_max_pumpen = off : return	'Flanke Reset
#alarm_max_zeit
lcd_param=&B00000001 : gosub LCD_WRITECMD 'Display lschen
'   gosub write_time
'   lcd_param = schraegstrich     : gosub LCD_WRITECHAR
'   gosub write_food
'   gosub write_leerz
   lcd_param = oo_    : gosub LCD_WRITECHAR     '1
   lcd_param = kk_    : gosub LCD_WRITECHAR     '2
   lcd_param = Ausr    : gosub LCD_WRITECHAR : gosub LCD_WRITECHAR        '15
meldung_aktiv = on : flanke_alarm_max_pumpen = on : gosub beep_kurz : gosub pause : return

#Daueralarm
if meldung_aktiv = on and (flanke_alarm_alarm = on or flanke_alarm_solar = on or flanke_Leermeldesonde = on or flanke_kein_wasser_pumpe = on or flanke_kein_wasser_tauchs = on)then hupe_ein= on  : return

#Data_to_pc
print (mess_ko * 5)- 365 ;" " ;(mess_pa * 5)- 365 : return 'Koch, Past-Temp zum PC

'Funktion Keyboard
#Keyboard
a_keyb = ON     'Ausgang Keyboard aktiv
deact hupe_ein
deact relais_7
deact a_batt_ein
deact relais_2
deact relais_3
deact relais_4
deact relais_5
deact relais_6
deact lcd_rs
deact lcd_rw
deact port11
deact port12

keyb = &HFF        'auf Anfangswert setzen
if a_batt_ein = ON then keyb= 5     'Tasten abfragen
if relais_2 = ON then keyb= 2
if relais_3 = ON then keyb= 11
if relais_4 = ON then keyb= 9
if relais_5 = ON then keyb= 6
if relais_6 = ON then keyb= 3
if relais_7 = ON then keyb= 8
if hupe_ein= ON then keyb= 0
if lcd_rs = ON then keyb= 1
if lcd_rw = ON then keyb= 4
if port11 = ON then keyb= 7
if port12 = ON then keyb= 10
a_keyb = OFF 'Ausgang Keyboard Aktiv aus

if keyb_flanke = ON and keyb <> &HFF then goto aktiv                      'Flanke keyboard
if keyb = &HFF then keyb_flanke = ON : return
#aktiv
keyb_flanke = OFF
if fkt1 = ON or fkt2 = on or fkt3 = on or FKT4 = ON or fkt5 = ON or FKT6 = on or FKT7 = on or disp_fkt9 = on then goto k00

'Anzeige umschalten						Grundmenu-Funktionen
if keyb <> 11 then goto k00   'Taste #
if disp_batt = off and disp_time = off then goto k21
if disp_batt = on then goto k22
if disp_time = on then goto k23
#k21
disp_batt = on : return 'Anzeige Batterie-Spannnung
#k22
disp_batt = off : disp_time = on : return 'Anzeige Zeit
#k23
disp_time = off : return 'Anzeige Temp Past

#k00
'Alarm aus und Gar-Zeit Reset mit Eingabe von "0" im Grundmenu
if keyb <> 0 then goto k001 'im Grundmenu?
if meldung_aktiv = off then time_ko = 0 'Reset nur wenn keine Meldungsquit
meldung_aktiv = off : hupe_ein = off 	'Reset Alarm-meldung und Hupe im Grundmenu

#k001
if keyb = 10 then goto reset                   'Abbruch Taste?
if fkt1 = ON then goto eing_1                   'Eingabe luft Pumpzeit?
if fkt2 = ON then goto eing_2                  'Eingabe luft Timer?
if fkt3 = on then goto eingabe_count_down
if fkt4 = on then return                       'Spannungsanzeige
if fkt5 = on then goto eing_5		'Eingabe Tauchsieder
if fkt6 = on then goto eing_6                       'Eingabe luft Verfahren
if fkt7 = ON then goto eing_7                  'Eingabe luft Uhr?
if disp_fkt9 = ON then goto eing_9             'Eingabe luft Hand?

'Pumpzeit und Temperatur eingeben
#key1
if keyb <> 1 then goto key2
fkt1 = on : lcd_param=&B00000001 : gosub LCD_WRITECMD  'Anzeige lschen
#disp_pump_max
    lcd_param = 1 : gosub LCD_GOTOLINE
    if fkt_past = off and fkt_water_cook = off then gosub write_cook else gosub write_pump
     gosub write_leerz
'    lcd_param = Strich : gosub LCD_WRITECHAR
    gosub write_water
    lcd_param = Doppelp    : gosub LCD_WRITECHAR
    value = ein_fuer : kein_komma = ON : gosub WRITEVALUE        'Pumpzeit
    gosub write_min
    gosub WRITE_LEERZ

    lcd_param = 2 : gosub LCD_GOTOLINE
    if dryer_on = on then goto dryer_on
     gosub write_cook
     lcd_param = &H2D    : gosub LCD_WRITECHAR
     goto display_temp   '8
#dryer_on
    gosub write_cooling
#display_temp
    gosub write_temp
    lcd_param = Doppelp    : gosub LCD_WRITECHAR
    lcd_param = 2: gosub set_index_eeprom : input# value 'Pumpzeit
    kein_komma = ON : gosub WRITEVALUE        'Beep-Temp
    lcd_param = HOCHZ    : gosub LCD_WRITECHAR
    lcd_param = C_    : gosub LCD_WRITECHAR
    gosub WRITE_LEERZ
lcd_param=&B00001111 : gosub LCD_WRITECMD'**** Cursor blinken ein
if eingabe_teil_2 = off then lcd_param=&H8C else lcd_param=&HCB 'Cursor auf best. Position
gosub LCD_WRITECMD
return

'Eingabe Pumpzeit
#eing_1
if eingabe_teil_2 = on then goto pu_eing_teil_2
if keyb = 11 then goto pu_end_teil_1 	'keine neue Eingabe?
if stelle_1 = off then ein_fuer = keyb else ein_fuer = (10 * ein_fuer ) + keyb
stelle_1 = ON : goto disp_pump_max
#pu_end_teil_1
stelle_1 = OFF : eingabe_teil_2 = on : goto disp_pump_max

'Eingabe Cook-temp
#pu_eing_teil_2
if keyb = 11 then goto pu_end_teil_2 'keine neue Eingabe?
if stelle_1 = ON then goto p_2_stelle_2
lcd_param = 2: gosub set_index_eeprom : print# keyb  'Kochtemp
stelle_1 = ON : goto disp_pump_max  '1.Stelle
#p_2_stelle_2
lcd_param = 2: gosub set_index_eeprom : input# value 'alten Wert lesen
value = (10 * value) + keyb : lcd_param = 2: gosub set_index_eeprom : print# value : goto disp_pump_max  'weitere Daten nach EEprom
#pu_end_teil_2
stelle_1 = OFF : eingabe_teil_2 = off  : goto disp_pump_max

'Schaltuhr
#key2
if keyb <> 2 then goto key3
fkt2 = ON  : lcd_param=&B00000001 : gosub LCD_WRITECMD  '

#display_timer
    lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile anw.
    gosub write_time
    lcd_param = rr_    : gosub LCD_WRITECHAR     '5
    lcd_param = DOPPELP    : gosub LCD_WRITECHAR     '6
    lcd_param = 4 : gosub set_index_eeprom : input# value 'Stunde
    kein_komma = ON : gosub WRITEVALUE
    lcd_param = DOPPELP     : gosub LCD_WRITECHAR     '1
    lcd_param = 5 : gosub set_index_eeprom : input# value 'Minute
    kein_komma = ON  : gosub WRITEVALUE: gosub write_leerz

    lcd_param = 2 : gosub LCD_GOTOLINE           '2.Zeile anw.
    lcd_param = oo_    : gosub LCD_WRITECHAR     '7
    lcd_param = nn_    : gosub LCD_WRITECHAR     '9
'    lcd_param = Strich    : gosub LCD_WRITECHAR     '9
    gosub write_time
    lcd_param = DOPPELP    : gosub LCD_WRITECHAR     '6
    value = su_time : kein_komma = ON : gosub WRITEVALUE
    gosub write_min
    gosub write_leerz
lcd_param=&B00001111 : gosub LCD_WRITECMD'**** Cursor blinken ein
if eingabe_teil_2 = off then lcd_param=&B10000110 else lcd_param=&B10001001 'Cursor auf best. Position
if eingabe_teil_3 = on then lcd_param=&B11000111
gosub LCD_WRITECMD
return

'Eingabe Zeit Timer
#eing_2
if eingabe_teil_2 = on then goto su_eing_teil_2
if eingabe_teil_3 = on then goto su_eing_teil_3

if keyb = 11 then goto su_01 	'keine neue Eingabe?
if stelle_1 = ON then goto hr_1 'Stunde
stelle_1 = ON : lcd_param = 4 : gosub set_index_eeprom : print# keyb : goto display_timer
#hr_1
if keyb = 11 then su_01'Zeichen #?
lcd_param = 4 : gosub set_index_eeprom : input# value
value =  (10 * value) + keyb : gosub set_index_eeprom : print# value :  goto display_timer
#su_01
stelle_1 = OFF : eingabe_teil_2 = on : eingabe_teil_3 = off  : goto display_timer

#su_eing_teil_2                                 'Eingabe Minute
if keyb = 11 then goto su_02 	'keine neue Eingabe?
if stelle_1 = ON then goto mi_1
stelle_1 = ON : lcd_param = 5 : gosub set_index_eeprom : print# keyb : goto display_timer
#mi_1
if keyb = 11 then su_01'Zeichen #?
lcd_param = 5 : gosub set_index_eeprom : input# value
value =  (10 * value) + keyb : gosub set_index_eeprom : print# value :  goto display_timer
#su_02
stelle_1 = OFF : eingabe_teil_2 = off : eingabe_teil_3 = on : goto display_timer

'Eingabe Dauer
#su_eing_teil_3                                 'Eingabe Dauer
if keyb = 11 then goto end_su_03	'keine neue Eingabe?
if stelle_1 = off then su_time = keyb else su_time = (10 * su_time ) + keyb
stelle_1 = ON : goto display_timer
#end_su_03
 stelle_1 = OFF : eingabe_teil_2 = off : eingabe_teil_3 = off  : goto display_timer

'Eingabe Count-down
#key3
if keyb <> 3 then goto key4
fkt3 = ON : lcd_param=&B00000001 : gosub LCD_WRITECMD 'Display lschen

#display_count_down
    lcd_param = 1 : gosub LCD_GOTOLINE           '2.Zeile anw.
    gosub write_alarm
    gosub write_leerz
    lcd_param = ii_    : gosub LCD_WRITECHAR     '2
    lcd_param = nn_    : gosub LCD_WRITECHAR     '3
    lcd_param = DOPPELP    : gosub LCD_WRITECHAR     '2
    value = count_down: kein_komma = ON : gosub WRITEVALUE    'Anzeige Uhrzeit hour
    gosub write_min

    lcd_param = 2 : gosub LCD_GOTOLINE           '1.Zeile des Displays wird aktiviert
    lcd_param = L_    : gosub LCD_WRITECHAR
    lcd_param = ii_    : gosub LCD_WRITECHAR
    lcd_param = dd_    : gosub LCD_WRITECHAR
    lcd_param = Strich    : gosub LCD_WRITECHAR
    gosub write_alarm
    lcd_param = doppelp    : gosub LCD_WRITECHAR
    if alarm_deckel = on then gosub write_on else gosub write_off
lcd_param=&B00001111 : gosub LCD_WRITECMD'**** Cursor blinken ein
if eingabe_teil_2 = off then lcd_param=&B10001001 else lcd_param=&B11001010 'Cursor auf best. Position
gosub LCD_WRITECMD
    return

'Eingabe Count-down
#eingabe_count_down
if eingabe_teil_2 = on then goto lid_alarm
if keyb = 11 then goto end_count_down	'keine neue Eingabe?
if stelle_1 = off then count_down = keyb else count_down = (10 * count_down ) + keyb
stelle_1 = on : goto display_count_down
#end_count_down
eingabe_teil_2 = on : stelle_1 = off : goto display_count_down

'Eingabe Deckel-Alarm
#lid_alarm
if keyb = 11 then goto alarm_000
if keyb = 1 then alarm_deckel = on else alarm_deckel = off :goto display_count_down
#alarm_000
eingabe_teil_2 = off : goto display_count_down

'Spannungsanzeige
#key4
if keyb <> 4 then goto key5
fkt4 = ON  : lcd_param=&B00000001 : gosub LCD_WRITECMD 'Display loeschen
#display_spannung
    lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile des Displays wird aktiviert
    lcd_param = U_    : gosub LCD_WRITECHAR
    lcd_param = Strich    : gosub LCD_WRITECHAR
    lcd_param = B_    : gosub LCD_WRITECHAR
    lcd_param = aa_    : gosub LCD_WRITECHAR
    lcd_param = tt_ : gosub LCD_WRITECHAR : gosub LCD_WRITECHAR
    lcd_param = DOPPELP : gosub LCD_WRITECHAR
    value = u_batt : gosub spannungswert : gosub WRITEVALUE       'Batteriespannung
    lcd_param = V_    : gosub LCD_WRITECHAR

    lcd_param = 2       : gosub lcd_gotoline    '2.Zeile des Displays wird aktiviert
    lcd_param = U_    : gosub LCD_WRITECHAR
    lcd_param = Strich    : gosub LCD_WRITECHAR
    lcd_param = O_    : gosub LCD_WRITECHAR
    lcd_param = uu_    : gosub LCD_WRITECHAR
    lcd_param = tt_ : gosub LCD_WRITECHAR
    gosub write_leerz
'    lcd_param = zwei_ : gosub LCD_WRITECHAR
    lcd_param = DOPPELP    : gosub LCD_WRITECHAR
    value = u_ausg : gosub spannungswert : gosub WRITEVALUE
    lcd_param = V_    : gosub LCD_WRITECHAR
    gosub write_leerz
    return

'Trockner/Solarkhlung ein
#key5
if keyb <> 5 then goto key6 'Anzeige nur Status Ausgnge
fkt5 = ON : lcd_param=&B00000001 : gosub LCD_WRITECMD
#display_dryer
     lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile des Displays wird aktiviert
     gosub write_dryer
     lcd_param = doppelp : gosub LCD_WRITECHAR
     if dryer_on = on then gosub write_on else gosub write_off

     lcd_param = 2 : gosub LCD_GOTOLINE           '1.Zeile des Displays wird aktiviert
     gosub write_cooling
     lcd_param = doppelp : gosub LCD_WRITECHAR
     if kuehlen = on then gosub write_on else gosub write_off
lcd_param=&B00001111 : gosub LCD_WRITECMD'**** Cursor blinken ein
if eingabe_teil_2 = off then lcd_param=&B10000110 else lcd_param=&B11001000 'Cursor auf best. Position
gosub LCD_WRITECMD
return

#eing_5
if eingabe_teil_2 = on then goto eing_cooling
'Trockner ein
#eing_dryer
if keyb = 11 then goto alarm_001
if keyb = 1 then dryer_on = on else dryer_on = off :goto display_dryer': lcd_param = 3 : gosub set_index_eeprom : print# save_eeprom_flags
#alarm_001
eingabe_teil_2 = on : goto display_dryer

'Khlen ein
#eing_cooling	'Anwahl Khlen
if keyb = 11 then goto kuehl_1 'Weiter mit nchster Eingabe bei #?
if keyb = 1 then kuehlen = on else kuehlen = off : goto display_dryer
#kuehl_1
eingabe_teil_2 = off : goto display_dryer

'Verfahren Anwahl
#key6
if keyb <> 6 then goto key7
fkt6 = on : lcd_param=&B00000001 : gosub LCD_WRITECMD '// Display loeschen
#disp_nachf
     lcd_param=1 : gosub LCD_GOTOLINE
     gosub write_rotate
     lcd_param = Doppelp    : gosub LCD_WRITECHAR
    if position_ein = on then gosub write_on else gosub write_off

     lcd_param=2 : gosub LCD_GOTOLINE
     gosub write_time
     lcd_param = doppelp    : gosub LCD_WRITECHAR
     open# for read : input# value : close# : kein_komma = on : gosub WRITEVALUE 	'Verfahrzeit aus EEprom
     lcd_param = ss_    : gosub LCD_WRITECHAR
     gosub WRITE_LEERZ
lcd_param=&B00001111 : gosub LCD_WRITECMD'**** Cursor blinken ein
if eingabe_teil_2 = off then lcd_param=&B10000111 else lcd_param=&B11000101 'Cursor auf best. Position
gosub LCD_WRITECMD
return

'Anwahl Rotate ein/aus
#eing_6
if eingabe_teil_2 = on then goto v_teil_2
if keyb <> 11 then goto verf04 'Weiter mit nchster Eingabe bei #?
eingabe_teil_2 = on: stelle_1 = off : goto disp_nachf
#verf04
if keyb = 1 then position_ein = on else position_ein = off : 'lcd_param = 3 : gosub set_index_eeprom : print# save_eeprom_flags
goto disp_nachf

'Eingabe Verfahrzeit
#v_teil_2
if keyb = 11 then goto v_reset	'keine neue Eingabe
if stelle_1 = on then goto verf_stelle_2
lcd_param = 1 : gosub set_index_eeprom : print# keyb 'Verfahrzeit
stelle_1 = on : goto disp_nachf  'Daten nach EEprom
#verf_stelle_2
open# for read : input# value : close# 'alten Wert lesen
value = (10 * value) + keyb : lcd_param = 1 : gosub set_index_eeprom : print# value :goto disp_nachf  'weitere Daten nach EEprom
#v_reset
eingabe_teil_2 = off : stelle_1 = off : goto disp_nachf
goto disp_nachf

'Eingabe Uhrzeit
#key7
if keyb <> 7 then goto key9                  '
fkt7 = ON : lcd_param=&B00000001 : gosub LCD_WRITECMD 'Display lschen
#display_zeit
    lcd_param = 1 : gosub LCD_GOTOLINE           '2.Zeile anw.
    gosub write_time
    lcd_param = Doppelp    : gosub LCD_WRITECHAR     '5
    value = hour  : kein_komma = ON : gosub WRITEVALUE    'Anzeige Uhrzeit hour
    lcd_param = DOPPELP : gosub LCD_WRITECHAR
    value = minute : kein_komma = ON : gosub WRITEVALUE            'minute
lcd_param=&B00001111 : gosub LCD_WRITECMD'**** Cursor blinken ein
if eingabe_teil_2 = off then lcd_param=&B10000101 else lcd_param=&B10001000 'Cursor auf best. Position
gosub LCD_WRITECMD
    return

'Eingabe Zeit
#eing_7
if eingabe_teil_2 = on then goto eing_teil_2
if keyb = 11 then goto h01  'Zeichen #?
if stelle_1 = off then hour = keyb else hour = (10 * hour ) + keyb
stelle_1 = on : Zeit_ueber_Tastur = on : goto display_zeit
#h01
stelle_1 = OFF : eingabe_teil_2 = on : goto display_zeit

#eing_teil_2			'Eingabe Minute
if keyb = 11 then goto end_inp_time 	'keine neue Eingabe?
if stelle_1 = off then minute = keyb else minute = (10 * minute ) + keyb
stelle_1 = on : Zeit_ueber_Tastur = on : goto display_zeit
#end_inp_time
stelle_1 = OFF : eingabe_teil_2 = off :goto display_zeit

'Handebene
#key9
if keyb <> 9 then return
disp_fkt9 = on  : lcd_param=&B00000001 : gosub LCD_WRITECMD 'Display lschen

#Anzeige_Handebene
    lcd_param = 1 : gosub LCD_GOTOLINE           '1.Zeile anw.
    lcd_param = B_    : gosub LCD_WRITECHAR
    lcd_param = aa_    : gosub LCD_WRITECHAR
    lcd_param = S_    : gosub LCD_WRITECHAR
    lcd_param = oo_    : gosub LCD_WRITECHAR
    gosub write_leerz
    lcd_param = R_    : gosub LCD_WRITECHAR
    lcd_param = oo_    : gosub LCD_WRITECHAR
    gosub write_leerz
    lcd_param = D_    : gosub LCD_WRITECHAR
    lcd_param = rr_    : gosub LCD_WRITECHAR
    gosub write_leerz
    lcd_param = P_    : gosub LCD_WRITECHAR
    lcd_param = uu_    : gosub LCD_WRITECHAR
    gosub write_leerz
    lcd_param = H_    : gosub LCD_WRITECHAR
    lcd_param = ee_    : gosub LCD_WRITECHAR
'    lcd_param = A_    : gosub LCD_WRITECHAR
'    lcd_param = ll_    : gosub LCD_WRITECHAR
'    gosub write_leerz : gosub write_leerz

lcd_param = 2 : gosub LCD_GOTOLINE
lcd_param = eins_    : gosub LCD_WRITECHAR
if batt_ein = ON then lcd_param = A_ else lcd_param = pp_ : gosub LCD_WRITECHAR
lcd_param = zwei_    : gosub LCD_WRITECHAR
if solar_off = ON then lcd_param = A_ else lcd_param = pp_ : gosub LCD_WRITECHAR
gosub write_leerz
 lcd_param = drei_    : gosub LCD_WRITECHAR
 if n_rechts = ON then lcd_param = A_ else lcd_param = pp_  : gosub LCD_WRITECHAR
gosub write_leerz
 lcd_param = vier_    : gosub LCD_WRITECHAR
 if dryer = ON then lcd_param = A_ else lcd_param = pp_ : gosub LCD_WRITECHAR
gosub write_leerz
 lcd_param = fuenf_    : gosub LCD_WRITECHAR
 if pump = ON then lcd_param = A_ else lcd_param = pp_ : gosub LCD_WRITECHAR
gosub write_leerz
 lcd_param = sechs_    : gosub LCD_WRITECHAR
 if schaltuhr = ON then lcd_param = A_ else lcd_param = pp_  : gosub LCD_WRITECHAR
'lcd_param = sieben_    : gosub LCD_WRITECHAR
'if relais_7 = ON then lcd_param = A_ else lcd_param = pp_ : gosub LCD_WRITECHAR
return

#eing_9
fkt9 = on
if keyb <> 5 then goto m_fkt_2
if pump = off then pump = on else pump = off : goto Anzeige_Handebene    'Pumpe ein

#m_fkt_2
if keyb <> 4 then goto m_fkt_3
if dryer = off then dryer = on else dryer = off : goto Anzeige_Handebene

#m_fkt_3
if keyb <> 3 then goto m_fkt_4
if n_rechts = off then n_rechts = on else n_rechts = off : goto Anzeige_Handebene

#m_fkt_4
if keyb <> 6 then goto m_fkt_5
if schaltuhr = off then schaltuhr = on else schaltuhr = off : goto Anzeige_Handebene

#m_fkt_5
if keyb <> 1 then m_fkt_6
if batt_ein = off then batt_ein = on else batt_ein = off : goto Anzeige_Handebene

#m_fkt_6
if keyb <> 2 then goto Anzeige_Handebene
if solar_off= off then solar_off= on else solar_off= off : goto Anzeige_Handebene

#Reset
lcd_param=&B00001100 : gosub LCD_WRITECMD' Cursor blinken aus
fkt1 = OFF : fkt2 = OFF : fkt3 = OFF
fkt4 = OFF : fkt5 = OFF : fkt6 = OFF : fkt7 = OFF : fkt9 = OFF : disp_fkt9 = off
stelle_1 = OFF  : eingabe_teil_2 = off : eingabe_teil_3 = off : eingabe_teil_4 = off
meldung_aktiv = off : hupe_ein = off: return  'Funktionen aus und Ende

' Kleine Hilfs Unterprogramme
#pump_on
if ein_fuer = 0 or fkt9 = on or (dryer = off and sensor_3 > 200) then return     'Max-Zeit Pumpe ein berwachen + Empty-Level
pump = on : gosub output : return

#beep_kurz
hupe_ein= on : gosub output : pause 150 : hupe_ein= off : return

#pause
pause 60 : return

'Leerzeichen schreiben
#WRITE_LEERZ
lcd_param = LEERZ : gosub LCD_WRITECHAR : return

'Wert Batterie umrechnen
#spannungswert
'value = 77*(value -55)/156+28
'value =  70*(u_batt-125)/118+74
value =  121*(value-82)/144+77  'Y=12,1*(X-89)/144+7,7
return

'Umrechnung Temp-Wert
#temp_value
    value = (lcd_param * 5)-365:  gosub WRITEVALUE       'Temperatur Kochen
    lcd_param = HOCHZ    : gosub LCD_WRITECHAR
    lcd_param = C_    : gosub LCD_WRITECHAR
    gosub WRITE_LEERZ : return

'Kochtemp berechnen
#kochtemp
lcd_param = 2 : gosub set_index_eeprom : input# value '2.Wert im EEprom ist Kochtemp
value = ((value* 10) + 365) / 5 : return

#set_index_eeprom
sys &h93 &h819d,&hB7CB,&hB692,&hB7CA,&hB691,lcd_param + lcd_param - 2 : return 'Zeiger 0; 2; 4; 6 etc

#write_alarm
    lcd_param = A_    : gosub LCD_WRITECHAR     '1
    lcd_param = ll_    : gosub LCD_WRITECHAR     '2
    lcd_param = aa_    : gosub LCD_WRITECHAR     '3
    lcd_param = rr_    : gosub LCD_WRITECHAR     '4
    lcd_param = mm_    : gosub LCD_WRITECHAR : return
#write_time
     lcd_param = T_    : gosub LCD_WRITECHAR
     lcd_param = ii_    : gosub LCD_WRITECHAR
     lcd_param = mm_    : gosub LCD_WRITECHAR
     lcd_param = ee_    : gosub LCD_WRITECHAR : return
#write_temp
     lcd_param = T_    : gosub LCD_WRITECHAR
     lcd_param = ee_    : gosub LCD_WRITECHAR
     lcd_param = mm_    : gosub LCD_WRITECHAR
     lcd_param = pp_    : gosub LCD_WRITECHAR : return
#write_cook
     lcd_param = C_    : gosub LCD_WRITECHAR
     lcd_param = oo_    : gosub LCD_WRITECHAR : gosub LCD_WRITECHAR
     lcd_param = kk_    : gosub LCD_WRITECHAR : return
#write_dryer
     lcd_param = D_    : gosub LCD_WRITECHAR     '1
     lcd_param = rr_    : gosub LCD_WRITECHAR
     lcd_param = yy_    : gosub LCD_WRITECHAR
     lcd_param = ee_    : gosub LCD_WRITECHAR
     lcd_param = rr_    : gosub LCD_WRITECHAR :return
#write_cooling
     lcd_param = C_    : gosub LCD_WRITECHAR     '1
     lcd_param = oo_    : gosub LCD_WRITECHAR : gosub LCD_WRITECHAR
     lcd_param = ll_    : gosub LCD_WRITECHAR
     lcd_param = ii_    : gosub LCD_WRITECHAR
     lcd_param = nn_    : gosub LCD_WRITECHAR
     lcd_param = gg_    : gosub LCD_WRITECHAR: Return
#write_rotate
     lcd_param = R_    : gosub LCD_WRITECHAR
     lcd_param = oo_    : gosub LCD_WRITECHAR
     lcd_param = tt_    : gosub LCD_WRITECHAR
     lcd_param = aa_    : gosub LCD_WRITECHAR
     lcd_param = tt_    : gosub LCD_WRITECHAR
     lcd_param = ee_    : gosub LCD_WRITECHAR : Return
#write_solar
     lcd_param = S_    : gosub LCD_WRITECHAR
     lcd_param = oo_    : gosub LCD_WRITECHAR
     lcd_param = ll_    : gosub LCD_WRITECHAR
     lcd_param = aa_    : gosub LCD_WRITECHAR
     lcd_param = rr_    : gosub LCD_WRITECHAR  :return
#write_water
    lcd_param = W_    : gosub LCD_WRITECHAR
    lcd_param = aa_    : gosub LCD_WRITECHAR
    lcd_param = tt_    : gosub LCD_WRITECHAR
    lcd_param = ee_    : gosub LCD_WRITECHAR
    lcd_param = rr_    : gosub LCD_WRITECHAR  :return
#write_pump
    lcd_param = P_    : gosub LCD_WRITECHAR
    lcd_param = uu_    : gosub LCD_WRITECHAR
    lcd_param = mm_    : gosub LCD_WRITECHAR
    lcd_param = pp_    : gosub LCD_WRITECHAR  :return
#write_on
     lcd_param = oo_    : gosub LCD_WRITECHAR     '11
     lcd_param = nn_ : gosub LCD_WRITECHAR : gosub WRITE_LEERZ: return
#write_off
     lcd_param = oo_    : gosub LCD_WRITECHAR     '11
     lcd_param = ff_    : gosub LCD_WRITECHAR  '12
     gosub LCD_WRITECHAR : return
#write_min
    lcd_param = mm_    : gosub LCD_WRITECHAR     '1
    lcd_param = ii_    : gosub LCD_WRITECHAR     '2
    lcd_param = nn_    : gosub LCD_WRITECHAR     :return
#write_hotW
    lcd_param = hh_    : gosub LCD_WRITECHAR
    lcd_param = oo_    : gosub LCD_WRITECHAR
    lcd_param = tt_     : gosub LCD_WRITECHAR
    lcd_param = W_     : gosub LCD_WRITECHAR: return

'*** LCD_Initialisierung ***
#LCD_INIT
  lcd_e=0        'Instruction-Mode
  gosub pause
  lcd_port = OFF ' alle ports 0
  lcd_port=&B00000010 : lcd_e=1 : lcd_e=0 'mit 8-Bit-Command in 4-Bit-Modus umschalten
  lcd_param=&B00101100 : gosub LCD_WRITECMD' Zeilen und Font einstellen
  lcd_param=&B00001100 : gosub LCD_WRITECMD'Display an
  lcd_param=&B00000001 : gosub LCD_WRITECMD'Display lschen
  lcd_port= &B00000110 : gosub LCD_WRITECMD 'Auto inkrement

  lcd_param = P_    : gosub LCD_WRITECHAR
  lcd_param = aa_    : gosub LCD_WRITECHAR
  lcd_param = nn_    : gosub LCD_WRITECHAR
  lcd_param = tt_    : gosub LCD_WRITECHAR
  lcd_param = aa_    : gosub LCD_WRITECHAR
   gosub write_leerz
  lcd_param = rr_    : gosub LCD_WRITECHAR
  lcd_param = ee_    : gosub LCD_WRITECHAR
  lcd_param = ii_    : gosub LCD_WRITECHAR
  lcd_param = Punkt    : gosub LCD_WRITECHAR : gosub LCD_WRITECHAR : gosub LCD_WRITECHAR

  lcd_param = 2 : gosub LCD_GOTOLINE           '1.Zeile anw.
  lcd_param = V_    : gosub LCD_WRITECHAR 'Versions-Kennung
  gosub WRITE_LEERZ
  lcd_param = drei_    : gosub LCD_WRITECHAR : gosub pause : return

'LCD-Programme
#WRITEVALUE
if abs(value) >= 1000 then lcd_param = NULL + ((value mod 10000)/1000) else goto w01 ' Tausender-Dezimalstelle
gosub LCD_WRITECHAR
#w01
if abs(value) >= 100 then lcd_param = NULL + ((value mod 1000)/100) else goto  w02 ' Hunderter-Dezimalstelle
gosub LCD_WRITECHAR
#w02
if abs(value) >= 10 then lcd_param = NULL + ((value mod 100)/10) else lcd_param = null ' Zehner-Dezimalstelle mit einer fhrenden 0
gosub LCD_WRITECHAR
#w03
if kein_komma = ON then goto w001
lcd_param = punkt :gosub lcd_writechar

#w001
kein_komma = OFF
lcd_param = NULL + value mod 10 ' einer Dezimalstelle ohne Leerzeichen
gosub LCD_WRITECHAR
return

' Zeilenwechsel
#LCD_GOTOLINE
  if lcd_param = 1 then lcd_param = &H80 : if lcd_param = 2 then lcd_param = &HC0
  goto LCD_WRITECMD

' LCD-Kommando
#LCD_WRITECMD
  lcd_rs=0 :  goto LCD_WRITE

' Zeichenausgabe
#LCD_WRITECHAR
  lcd_rs=1

' Kommando oder Zeichen an Display senden
#LCD_WRITE
  lcd_port = lcd_param shr 4  :  lcd_e = 1 : lcd_e = 0 ' Hi-Nibble
  lcd_port = lcd_param and &H0F : lcd_e = 1 : lcd_e = 0 ' Lo-Nibble
lcd_port = off: clock1 = off
return

   'Ausgnge rausgeben
#output
if fkt9 = off and pump = on then n_rechts = off  'Verriegelungen: nur ein "Stromfresser" an
if wahlschalter > wert_pos_6 then goto ein
batt_ein = on : solar_off = off : pump = off : schaltuhr = off : n_rechts = off : dryer = off
#ein
a_batt_ein  = batt_ein 'port 3
relais_2 = solar_off 'port4
relais_3 = Pump 'port5
relais_4 = dryer 'schaltuhr 'port8
relais_5 = n_rechts 'port7
'relais_6 = n_links 'dryer 'port6
relais_7 = schaltuhr 'dryer 'port6
pulse clock1 'bergabe an 74LS373
return
