Attribute VB_Name = "mSScom"
Option Explicit

' ***************************************
' Programmlisting Serielle Schnittstelle
' Com1, Com2, Com3, Com4
' ***************************************

' VB hat ein Schnittstellencontrol Mscomm32.ocx
' dieses muss mit Projekt\Components
' fuer das Projekt verfuegbar gemacht werden
' Das Control ermoeglicht den einfachen Zugriff
' auf die serielle Schnittstelle indem es die
' Windows API Funktionen kapselt.

' Damit ein VB-Programm auf einem fremden PC
' funktioniert muss im Windows-Verzeichnis
' neben msvbvm50.dll auch mscomm32.ocx vorhanden sein


' Seriell heisst, dass ein Byte in 8 Bits gewandelt
' wird. Diese Bits werden dann uebertragen.
' In der SchnittstellenNorm
'      V24 (EuropaNorm) oder RS-232 (InternationaleNorm)
' ist die Funktion und Bezeichnung der
' Schnittstellenleitungen festgelegt
' DTE = Sender dh. PC
'       Leitung 2 senden und Leitung 3 empfangen
' DCE = Empfaenger dh. Modem, Scanner oder Drucker
'       Leitung 3 senden und Leitung 2 empfangen

'  9 polig                     9 polig
'  DTE                         DCE
' DCD  1  --------------------- 1   DCD
' RXD  2  --------------------> 3   TXD
' TXD  3  <-------------------- 2   RXD
' DTR  4  --------------------> 6   DSR
' GND  5  <-------------------- 5   GND
' DST  6  --------------------> 4   DTR
' RTS  7  <-------------------- 8   CTS
' CTS  8  <-------------------- 7   RTS
' RI   9  <-------------------- 9   RI


'  25 polig                    25 polig
'  DTE                         DCE
' GND  7  --------------------- 7   GND
' TXD  2  --------------------> 3   RXD
' RXD  3  <-------------------- 2   TXD
' RTS  4  --------------------> 5   CTS
' CTS  5  <-------------------- 4   RTS
' DSR  6  <-------------------- 20  DTR
' DTR 20  --------------------> 6   DSR
' CD   8  <-------------------- 8   CD
' RI  22  <-------------------- 22  RI

'  9 polig                     25 polig
'  DTE                         DCE
' DCD  1  --------------------- 8   DCD
' RXD  2  --------------------> 2   TXD
' TXD  3  <-------------------- 3   RXD
' DTR  4  --------------------> 6   DSR
' GND  5  <-------------------- 7   GND
' DST  6  --------------------> 20  DTR
' RTS  7  <-------------------- 5   CTS
' CTS  8  <-------------------- 4   RTS
' RI   9  <-------------------- 22  RI

' Com1, Com3, Com4  9 polig
' Com2              9 oder 25 polig
' Kabel hat immer Buchsen

' TXD dient zum Daten senden
' RXD dient zum Daten empfangen
' Beide Geraete koennen daher gleichzeitig
' Daten senden und empfangen

' Bevor Daten gesendet werden wird mit
' RTS (Request to send) angefragt.
' Der Partner bestaetigt die Sendebreitschaft
' mit CTS (Clear to send)

' Die DSR (Data Set Ready) Leitung signalisiert
' dass ein DCE Partner eingeschaltet und betriebsbereit ist.

' Die DTR (Data Terminal Ready) Leitung signalisiert
' dass ein DTE Partner eingeschaltet und betriebsbereit ist.

' Ein spezieller Kommunikationsbaustein im PC
' uebernimmt den Datenaustausch
' PC/XT    dh.  8Bit-UART 8250
' PC ab AT dh. 16Bit-UART 16450
' Dieser Baustein kann ueber 8 Register programmiert
' werden. Bei VB ist dies jedoch nicht moeglich. Es werden
' Win-API-Funktionen benutzt die ueber das MSCOMM.OCX
' gekapselt sind.

' Das OCX hat 26 Eigenschaften
' z.B. CommPort  = Schnittstellennummer
'      Settings  = Schnittstellenparameter
'      PortOpen  = Oeffnen und schliessen der Schnittstelle
'      Input     = Empfangsdaten
'      InputLen  = Anzahl der Empfangsdaten
'      Output    = Sendedaten

' Schnittstelle initialisieren
' Comm1.CommPort=2
' Comm1.Settings="9600,N,8,1"
' Comm1.PortOpen=True

' Senden
' Comm1.Output="Sendedaten"

' Empfangen
' Text=Comm1.Input

' Schnittstelle schliessen
' Comm1.PortOpen=False

' Handshaking
' Hardwaremaessig ueber die Leitungen CTS und RTS
' Da nicht alle Geraete diese Signale unterstuetzen
' gibt es die Softwareloesung mit Steuerzeichen
' XON  = ASCII 19 oder STR-S  dh. Chr$(19)
' XOFF = ASCII 17 oder STR-Q  dh. Chr$(17)
' Dieses Verhalten laesst sich ueber die Eigenschaft
' Handshaking einstellen

' Tritt auf der Schnittstelle ein Ereignis auf
' ruft das MSComm.OCX die Ereignisprozedur
' Sub Comm1_OnComm() auf
' Fuer jedes moegliche Ereignis gibt es eine
' Konstante
' z.B.  MSCOMM_EV_RECEIVE wird gesetzt wenn
' Zeichen empfangen wurden. Damit dies geht
' muss die Eigenschaft RThreshold=1 sein.
' dh. es wird die Anzahl der Empfangszeichen angegeben
' wann das Ereignis ausgeloest werden soll
' Fuer Senden gibt es die Eigenschaft STreshold und
' das Ereignis MSCOMM_EV_SEND


'Problem
'VB6.0 sendet nichts wenn man comm1.output=chr(0)+chr(0) versucht
'VB5.0 sendet in diesem Fall



' *** Deklarationsteil fr globale Variablen

#If 0 Then

Prozedur 3964R   STX, DLE usw
Protokoll RK512  Telegrammaufbau

Prozedur:

Steuerung 1                 Steuerung 2

            STX 2
             <---------------------------------------------
            DLE (NAK)   10/(05)
             --------------------------------------------->
    
            Telegramm
    <----------------------------------------------
            
            DLE 10
    <----------------------------------------------
            ETX 3
    <----------------------------------------------
            BCC  (nur bei 3964R)
    <----------------------------------------------


            DLE (NAK)   10/05
            ----------------------------------------------->
    



            STX 2
             --------------------------------------------->
            DLE (NAK)   10/05
             <--------------------------------------------
    
        Reaktionstelegramm
    
     ---------------------------------------------->
            DLE 10
            ---------------------------------------------->
            ETX 3
     ---------------------------------------------->
            BCC  (nur bei 3964R)
     ---------------------------------------------->

            DLE (NAK)   10/05
    <-----------------------------------------------


Protokoll:

Aufbau des Telegrammkopfs

Der Telegrammkopf besteht aus 5 Datenworte, dh. 10 Bytes

Wort 0          0
Wort 1          Befehl          KC   AD = Daten senden
                                KC   ED = Daten holen
Wort 2          Ziel            DB-Nummer, DW-Nummer
Wort 3          Anzahl der Datenworte
Wort 4          Koordinierungsmerker


Beispiel:   00  00    41  44    10    08      00    06       FF    FF
                       A   D    DB16  DW8  Anzahl der DW 6 (dh.8,9,10,11,12,13)
                                  Kein Koordinierungsmerker

 
Aufbau des Reaktionstelegramms

Das Reaktionstelegramm besteht aus 2 Datenworte, dh. 4 Bytes


Wort 0          0
Wort1       0       Fehlernummer

Beispiel:       00   00      00    00       Fehlerfrei

            00   00      00    01       Fehler 1


01      Keine Reaktionsmeldung innerhalb von 30 Sekunden.
03 - 14     Hardwarefehler
15 - 20     Programmierfehler
21 - 40     Bedienungsfehler
41 - 58     Von der CP-Software erkannte Fehler




#End If

Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Global DSRStatus As Integer
Global CTSStatus As Integer
Global CDStatus As Integer
Global EVMsg As String
Global ERMsg As String
Global PortAktivModus As Integer


Global Const MB_OKCANCEL = 1
Global Const MB_ICONEXCLAMATION = 48
Global Const IDCANCEL = 2



'Aktuelle Schnittstelle
Global ComPort As Integer
Global ComPortSettings As String
Global PortSettings As String

Global RechnerName As String

' Strukturvariable zum Abspeichern der Comm-Parameter
Type CommParameterTyp
     BaudRate As Integer
     Paritt As String * 1
     DatenBits As Integer
     StopBits As Single
     Name As String
     Protokoll As Integer
End Type

' Maximale Anzahl an Comm-Ports
Global Const MaxCommNr = 4

' Fr jeden Comm-Port wird eine Strukturvariable definiert
'CommParameter(0)=Arbeitsbereich
'CommParameter(1..4)= Speicher fuer Com1 .. Com4
Global CommParameter(0 To MaxCommNr) As CommParameterTyp

'Steuerzeichen
Global Const STX = 2
Global Const ETX = 3
Global Const NAK = 5
Global Const DLE = &H10
Global Const CR = 13
Global Const LF = 10


Global QZZ As Integer
Global SendStep As Integer
Global RecvStep As Integer

Global SendData As String
Global bySendData(200) As Byte

Type tyRecvData
     typ As Integer
     DB As Integer
     DW As Integer
     anzBytes As Integer
     data As String
     BCC As Integer
End Type

Global RecvData As tyRecvData

'Ausgabe von Meldungen
Global Sobj As Object
Global Eobj As Object

Global lineNr As Integer

Global LastSendError As Integer
Global LastRecvError As Integer

Declare Sub CopyStringToBuffer Lib "kernel32" _
    Alias "RtlMoveMemory" ( _
            ByVal ZBuffer As Any, _
            ByVal QString As String, _
            ByVal anzahl As Long _
     )
Declare Sub CopyBufferToString Lib "kernel32" _
    Alias "RtlMoveMemory" ( _
            ByVal ZString As String, _
            ByVal QBuffer As Any, _
            ByVal anzahl As Long _
     )

Function Com_Init() As Integer


    Dim n As Integer
    Dim ret As Integer
    
    ' Fr alle vier COM-Ports Standardwerte:
    ' 9600 baud, keine Partitt, 8 Datenbits und 1 Stopbit.
    For n = 1 To 4
      CommParameter(n).BaudRate = 9600
      CommParameter(n).Paritt = "N"
      CommParameter(n).DatenBits = 8
      CommParameter(n).StopBits = 1
      CommParameter(n).Name = "COM" + Str(n)
      CommParameter(n).Protokoll = 0
    Next n
    
    ' Aber nur COM1 initialisieren
    ComPort = 1
    ComPortSettings = "Terminal 19200,N,8,1"
    PortSettings = "19200,N,8,1"
    
    fSSCom.Comm1.CommPort = 1
    fSSCom.Comm1.Settings = "19200,N,8,1"
    
    ' Com-Port oeffnen
    'Es gibt nun zwei Moeglichkeiten
    ' - Es steckt kein Kabel
    '
    ' - Es steckt ein Kabel aber Partner nicht bereit
    '    Es kommt 0xff oder oxfe dh. Break in Funktion: Comm1_OnComm
    
    
    ret = fSSCom.ComPortAuf
        
    lineNr = 1
    
    Com_Init = ret
    
End Function

Public Function Com_Ende()
    
     fSSCom.ComPortZu
    
End Function

Public Function Com_SetParam()
    'Schnittstellenparameter neu setzen
    If fSSCom.Comm1.PortOpen Then
        fSSCom.Comm1.PortOpen = False
        fSSCom.Comm1.CommPort = ComPort
        fSSCom.Comm1.Settings = PortSettings
        fSSCom.Comm1.PortOpen = True
    Else
        fSSCom.Comm1.CommPort = ComPort
        fSSCom.Comm1.Settings = PortSettings
    End If
   
End Function

Public Function Recv3964(zeichen As String, anz As Integer)
Dim code As Integer
Dim c1 As Integer
Dim c2 As Integer
Dim i As Integer
Dim z(10) As Byte

If anz = 0 Then Exit Function

    
    If anz = 1 Then
    
    CopyStringToBuffer VarPtr(z(0)), zeichen, 1
    code = z(0)
    
    Select Case code
           Case STX
                RecvDataShow Chr(STX)
                Sende3964 3  'DLE senden
                RecvStep = 1
                RecvData.data = ""
                
           Case DLE
                RecvDataShow Chr(DLE)
                'warten nach STX auf DLE
                If SendStep = 2 Then
                        QZZ = 0
                        Sende3964 2  'Nutzdaten senden
                End If
               
                'warten nach Daten auf DLE
                If SendStep = 3 Then
                  If CommParameter(ComPort).Protokoll = 1 Or _
                    CommParameter(ComPort).Protokoll = 3 Then
                     SendStep = 0
                     LastSendError = 0
                  End If
                  If CommParameter(ComPort).Protokoll = 2 Or _
                    CommParameter(ComPort).Protokoll = 4 Then
                     'Warten auf Reaktionstelegramm
                     SendStep = 4
                     
                     fSSCom.Timer1.Enabled = False
                     fSSCom.Timer1.Enabled = True
                  
                  End If
                  
                End If
                
           Case ETX
                RecvDataShow Chr(ETX)
                Sende3964 3  'DLE senden
                SendStep = 0
                
           Case NAK
                RecvDataShow Chr(NAK)
                SendStep = 0
           
           End Select

     Else
           
            
            RecvDataShow zeichen
            RecvData.data = RecvData.data + zeichen
            
            'Ohne Blockchek
            If CommParameter(ComPort).Protokoll = 1 Or _
            CommParameter(ComPort).Protokoll = 3 Then
                c1 = Asc(Mid(zeichen, anz, 1))
                c2 = Asc(Mid(zeichen, anz - 1, 1))
                If c1 = ETX And c2 = DLE Then
                    Sende3964 3  'DLE senden
                    RecvStep = 0
                    
                    RecvData.BCC = 0
                    
                    If Mid(RecvData.data, 3, 2) = "AD" Then
                    
                       RecvData.DB = Asc(Mid(RecvData.data, 5, 1))
                       RecvData.DW = Asc(Mid(RecvData.data, 6, 1))
                       RecvData.anzBytes = Asc(Mid(RecvData.data, 7, 1)) * 256 + Asc(Mid(RecvData.data, 8, 1))
                       RecvData.typ = 1
                       RecvData.data = Mid(RecvData.data, 11, Len(RecvData.data) - 12)
                       
                       Quittung 1
                    
                    
                    End If
                    
                    If Mid(RecvData.data, 3, 2) = "ED" Then
                       
                       RecvData.typ = 11
                       RecvData.data = Mid(RecvData.data, 11, Len(RecvData.data) - 12)
                    End If
                    
                    
                End If
            End If
            
            'Mit Blockcheck
            If CommParameter(ComPort).Protokoll = 2 Or _
            CommParameter(ComPort).Protokoll = 4 Then
                c1 = Asc(Mid(zeichen, anz - 1, 1))
                c2 = Asc(Mid(zeichen, anz - 2, 1))
                If c1 = ETX And c2 = DLE Then
                    c1 = Asc(Mid(zeichen, anz, 1)) 'BCC
                    Sende3964 3  'DLE senden
                    RecvStep = 0
                    
                    
                    If Mid(RecvData.data, 3, 2) = "AD" Then
                      RecvData.BCC = c1
                      RecvData.DB = Asc(Mid(RecvData.data, 5, 1))
                      RecvData.DW = Asc(Mid(RecvData.data, 6, 1))
                      RecvData.anzBytes = Asc(Mid(RecvData.data, 7, 1)) * 256 + Asc(Mid(RecvData.data, 8, 1))
                    
                      RecvData.typ = 1
                      RecvData.data = Mid(RecvData.data, 11, Len(RecvData.data) - 14)
                    End If
                    If Mid(RecvData.data, 3, 2) = "ED" Then
                      RecvData.typ = 11
                      RecvData.data = Mid(RecvData.data, 11, Len(RecvData.data) - 14)
                    End If
                    
                    
                    
                End If
            End If
            
     End If


End Function
Public Sub RecvDataShow(zeichen As String)
    Dim Lnge As Integer
    Dim Temp As Integer
    Dim i As Integer
    Dim code As Integer
    Dim Sbuffer As String
    Dim Ebuffer As String
    Dim t As String
    
    Dim a As Integer
    Dim e As Integer
    
    Static crlf As Integer
    
    Lnge = Len(zeichen)
   
    i = GetMilliSec
    t = Format(Time, "hh:mm:ss") + " " + Format(i, "000")

    

  If Lnge = 1 Then
  
  code = Asc(Mid(zeichen, 1, 1))
  
  Select Case code
       Case ETX
            Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + " >03(ETX)<" + vbCrLf
            Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + vbCrLf
            lineNr = lineNr + 1
            crlf = ETX
            
            
       Case STX
            Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + " >02(STX)<" + vbCrLf
            Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + vbCrLf
            lineNr = lineNr + 1
            
            crlf = STX
            
       Case NAK
            Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + " >05(NAK)<" + vbCrLf
            Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + vbCrLf
            lineNr = lineNr + 1
            
       Case DLE
            'Neue Zeile nach Datenende
            If Lnge > 1 Then
                Sbuffer = Sbuffer + vbCrLf
                Ebuffer = Ebuffer + vbCrLf
                lineNr = lineNr + 1
            End If
            
            Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + " >10(DLE)<" + vbCrLf
            Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + vbCrLf
            lineNr = lineNr + 1
            
       Case Else
         
            'Bei langen Nutzdaten kommen diese in mehreren Teilblcken
            If CommParameter(ComPort).Protokoll = 0 Then
               If code = Asc(vbCr) Then
                  Ebuffer = Ebuffer + vbCrLf
               Else
                    Ebuffer = Ebuffer + Chr$(code)
               End If
            Else
            '1. Zeichen
              If crlf = STX Then
                    Ebuffer = Format(lineNr, "000") + " " + t + " " + Hex$(code)
                    Sbuffer = Format(lineNr, "000") + " " + t
                    crlf = 0
              Else
              If crlf = ETX Then
                    Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + " >" + Format(Hex$(code), "00") + "(BCC)<" + vbCrLf
                    Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + vbCrLf
                    lineNr = lineNr + 1
                    crlf = 0
              Else
              'Folgezeichen
                    Ebuffer = Ebuffer + " " + Hex$(code)
                    crlf = 1
              End If
             End If
             End If
             
             
            
       End Select
       
    Else
    
    For i = 1 To Lnge
        
        code = Asc(Mid(zeichen, i, 1))
  
       Select Case code
       
       Case STX
            'lineNr = lineNr + 1
            Ebuffer = t + " " + Format(lineNr, "000") + " " + " >02(STX)< "
            Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + vbCrLf
            crlf = STX
       
       Case DLE
            'Neue Zeile nach Datenende
            If Lnge > 1 Then
                Sbuffer = Sbuffer + vbCrLf
                Ebuffer = Ebuffer + vbCrLf
                lineNr = lineNr + 1
            End If
            
            Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + " >10(DLE)<" + vbCrLf
            Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + vbCrLf
            lineNr = lineNr + 1
            
       Case ETX
            'Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + " >03(ETX)<" + vbCrLf
            Ebuffer = Ebuffer + " >03(ETX)<" + vbCrLf
            
            Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + vbCrLf
            lineNr = lineNr + 1
            crlf = ETX
            
            
    
       Case Else
         
            'Bei langen Nutzdaten kommen diese in mehreren Teilblcken
            If CommParameter(ComPort).Protokoll = 0 Then
               Ebuffer = Ebuffer + Chr$(code)
            Else
            '1. Zeichen
              If crlf = STX Then
                    Ebuffer = Format(lineNr, "000") + " " + t + " " + Hex$(code)
                    Sbuffer = Format(lineNr, "000") + " " + t
                    crlf = 0
              Else
              If crlf = ETX Then
                    Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + " >" + Format(Hex$(code), "00") + "(BCC)<" + vbCrLf
                    Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + vbCrLf
                    lineNr = lineNr + 1
                    crlf = 0
              Else
              'Folgezeichen
                    Ebuffer = Ebuffer + " " + Hex$(code)
                    crlf = 1
              End If
             End If
             End If
             
             
        End Select
      
    Next i

    End If
    
    'If CommParameter(ComPort).Protokoll > 0 Then
    'Sobj.SelText = Sbuffer
    'Sobj.Refresh
    'End If
    
    
    Eobj.SelText = Ebuffer
    Eobj.Refresh
    
    Rec = 1
    
    
    
End Sub


Function Sende3964(Step As Integer)

Static puffer As String
Dim cBBC As Byte


    Select Case Step
           Case 1         'STX senden
                SendStep = 2
                fSSCom.ComSende Chr(STX)
                SendDataShow Chr$(STX)
                
                QZZ = 0
                
                fSSCom.Timer1.Enabled = False
                fSSCom.Timer1.Enabled = True
                                
                LastSendError = 0
                
                 
                    
                 RecvData.DB = Asc(Mid(SendData, 5, 1))
                 RecvData.DW = Asc(Mid(SendData, 6, 1))
                 RecvData.anzBytes = Asc(Mid(SendData, 7, 1)) * 256 + Asc(Mid(SendData, 8, 1))
                 If Mid(SendData, 3, 2) = "AD" Then
                    RecvData.typ = 1
                 End If
                 If Mid(SendData, 3, 2) = "ED" Then
                    RecvData.typ = 11
                 End If
                 
                
           Case 11         'STX senden fr Quittung
                SendStep = 2
                fSSCom.ComSende Chr(STX)
                SendDataShow Chr$(STX)
                
                QZZ = 0
                
                fSSCom.Timer1.Enabled = False
                fSSCom.Timer1.Enabled = True
                                
                LastSendError = 0
                
                
                    
                
           Case 2         'Nutzdaten senden
                
                SendStep = 3
                MakeSendData SendData, puffer, cBBC
                
                fSSCom.Timer1.Enabled = False
                fSSCom.Timer1.Enabled = True
                
                
                '3964
                If CommParameter(ComPort).Protokoll = 1 Then
                    fSSCom.ComSende SendData + Chr$(DLE) + Chr$(ETX)
                    SendDataShow SendData + Chr$(DLE) + Chr$(ETX)
                End If
                
                '3964R d.h. mit Blockcheck
                If CommParameter(ComPort).Protokoll = 2 Then
                    fSSCom.ComSende SendData + Chr$(DLE) + Chr$(ETX) + Chr$(cBBC)
                    SendDataShow SendData + Chr$(DLE) + Chr$(ETX) + Chr$(cBBC)
                End If
                
                '3964R mit AS512 ohne Blockcheck
                If CommParameter(ComPort).Protokoll = 3 Then
                    fSSCom.ComSende SendData + Chr$(DLE) + Chr$(ETX)
                    SendDataShow SendData + Chr$(DLE) + Chr$(ETX)
                End If
                
                '3964R mit AS512 mit Blockcheck
                If CommParameter(ComPort).Protokoll = 4 Then
                    fSSCom.ComSende SendData + Chr$(DLE) + Chr$(ETX) + Chr$(cBBC)
                    SendDataShow SendData + Chr$(DLE) + Chr$(ETX) + Chr$(cBBC)
                End If
                
           Case 3         'DLE senden
                fSSCom.ComSende Chr$(DLE)
                SendDataShow Chr$(DLE)
                If RecvStep = 1 Then RecvStep = 2
                
           Case 4         'NAK senden
                fSSCom.ComSende Chr$(NAK)
                SendDataShow Chr$(NAK)
           
                
                
    End Select

'End If

End Function
Public Sub SendDataShow(zeichen As String)
' Empfangenes Zeichen im Textfeld ausgeben
    Dim Lnge As Integer
    Dim Temp As Integer
    Dim i As Integer
    Dim l As Integer
    Dim Sbuffer As String
    Dim Ebuffer As String
    Dim code As Integer
    Dim t As String
    
    Static crlf As Integer
    
    i = GetMilliSec
    t = Format(Time, "hh:mm:ss") + " " + Format(i, "000")
    
    'Steuerzeichen kommt einzeln
    Lnge = Len(zeichen)

    If Lnge = 1 Then
       
       code = Asc(Mid(zeichen, 1, 1))
  
       Select Case code
       Case ETX
            Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + " <03(ETX)>" + vbCrLf
            Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + vbCrLf
            lineNr = lineNr + 1
            
            crlf = ETX
            
       Case STX
            Sbuffer = Format(lineNr, "000") + " " + t + " " + Sbuffer + "<02(STX)>" + vbCrLf
            Ebuffer = Format(lineNr, "000") + " " + t + " " + Ebuffer + vbCrLf
            lineNr = lineNr + 1
            
            crlf = STX
            
       Case NAK
            Sbuffer = Format(lineNr, "000") + " " + t + " " + Sbuffer + "<05(NAK)>" + vbCrLf
            Ebuffer = Format(lineNr, "000") + " " + t + " " + Ebuffer + vbCrLf
            lineNr = lineNr + 1
            
       Case DLE
            If crlf = DLE Then
                crlf = 0
                Sbuffer = Sbuffer + vbCrLf
                Ebuffer = Ebuffer + vbCrLf
                lineNr = lineNr + 1
            End If
                  
                Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + " " + "<10(DLE)>" + vbCrLf
                Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + vbCrLf
                lineNr = lineNr + 1
            
       End Select
            
       Else
       
       'Nutzdaten mit DLE , ETX und BCC
       For i = 1 To Lnge
            
       code = Asc(Mid(zeichen, i, 1))
          
       Select Case code
       Case ETX
            If i = Lnge And (CommParameter(ComPort).Protokoll = 1 Or CommParameter(ComPort).Protokoll = 3) Or _
               i = Lnge - 1 And (CommParameter(ComPort).Protokoll = 2 Or CommParameter(ComPort).Protokoll = 4) Then
            Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + " <03(ETX)>" + vbCrLf
            Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + vbCrLf
            lineNr = lineNr + 1
            
            crlf = ETX
            End If
            
       Case DLE
             
            If i = Lnge - 1 And (CommParameter(ComPort).Protokoll = 1 Or CommParameter(ComPort).Protokoll = 3) Or _
               i = Lnge - 2 And (CommParameter(ComPort).Protokoll = 2 Or CommParameter(ComPort).Protokoll = 4) Then
                crlf = 0
                Sbuffer = Sbuffer + vbCrLf
                Ebuffer = Ebuffer + vbCrLf
                lineNr = lineNr + 1
            
                Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + " " + "<10(DLE)>" + vbCrLf
                Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + vbCrLf
                lineNr = lineNr + 1
            
            End If
            
       Case Else
            
            
            If CommParameter(ComPort).Protokoll = 0 Then
               Sbuffer = Sbuffer + Chr$(code)
            Else
            
                '1. Zeichen
                If crlf = STX Then
                    Sbuffer = Format(lineNr, "000") + " " + t + " " + Hex$(code)
                    Ebuffer = Format(lineNr, "000") + " " + t
                    crlf = DLE
                Else
                If crlf = ETX Then
                    crlf = 0
                    Sbuffer = Sbuffer + Format(lineNr, "000") + " " + t + " <" + Format(Hex(code), "00") + "(BCC)>" + vbCrLf
                    Ebuffer = Ebuffer + Format(lineNr, "000") + " " + t + vbCrLf
                    lineNr = lineNr + 1
                Else
                
                 'Folge Zeichen
                    Sbuffer = Sbuffer + " " + Hex$(code)
                    crlf = DLE
                
                End If
                End If
            End If
            
        End Select
        
        Next i
    
        End If
        
    Sobj.SelText = Sbuffer
    Sobj.Refresh
    
    If CommParameter(ComPort).Protokoll > 0 Then
    Eobj.SelText = Ebuffer
    Eobj.Refresh
    End If
    
    
' Empfangenes Zeichen jetzt (endlich) in Textfeld einfgen
    'Textfeld.SelText = Chr$(10) + Chr$(13)
 
 End Sub ' ZeichenAusgeben

Public Sub MakeSendData(Qdata As String, ByRef Zdata As String, ByRef cBBC As Byte)
    Dim i As Integer
    Dim l As Integer
    Dim k As Integer
    Dim Temp As Integer
    
    
    cBBC = 0
    
    l = Len(Qdata)
    k = 1
    
    For i = 1 To l
    
      Zdata = Zdata + Mid(Qdata, i, 1)
      cBBC = cBBC Xor Asc(Mid(Qdata, i, 1))
      k = k + 1
      
      Temp = Asc(Mid(Qdata, i, 1))
      If Temp = DLE Then
        Zdata = Zdata + Mid(Qdata, i, 1)
        cBBC = cBBC Xor Mid(Qdata, i, 1)
        k = k + 1
      End If
          
    Next i
       
    'DLE und ETX noch dazu
     cBBC = cBBC Xor &H10
     cBBC = cBBC Xor &H3
     
    
End Sub

Function DBRead(DB As Integer, DW As Integer, anzByte As Integer)
   
   If SendStep > 0 Then
       'Sendung luft noch
       DBRead = False
   Else
    
    'Telegrammkopf
    SendData = Chr(0) + Chr(0) + "ED"
    SendData = SendData + Chr(DB)
    SendData = SendData + Chr(DW)
    SendData = SendData + Chr(0)
    SendData = SendData + Chr(anzByte)       'Max. 64 Datenworte
    SendData = SendData + Chr(&HFF) + Chr(&HFF)
   
   
   'Senden starten
    Sende3964 1

   End If
    
End Function
Function DBWrite(DB As Integer, DW As Integer, anzByte As Integer, dByte() As Byte) As Integer

    Dim daten As String
    
    Dim i As Integer
    
    If SendStep > 0 Then
       'Sendung luft noch
       DBWrite = False
    Else
    
    'Telegrammkopf
    SendData = Chr(0) + Chr(0) + "AD"
    SendData = SendData + Chr(DB)
    SendData = SendData + Chr(DW)
    SendData = SendData + Chr(0)
    SendData = SendData + Chr(anzByte / 2)       'Max. 64 Datenworte
    SendData = SendData + Chr(&HFF) + Chr(&HFF)
                
    daten = ""
    For i = 1 To anzByte
      daten = daten + Chr(dByte(i - 1))
    Next i
    
    'Telegrammdaten
    SendData = SendData + daten
               
    'Senden starten
    Sende3964 1

    'Sendung angestossen evtl. warten auf Antwort
    DBWrite = True
    
    End If
    
End Function
Function Quittung(typ As Integer)
   
    DoEvents
    
    Sleep 200
    
    'Quittung ohne Fehler
    If typ = 1 Then
    SendData = Chr(0) + Chr(0) + Chr(0) + Chr(0)
    End If
    
    'Quittung mit Fehler
    If typ = 2 Then
    SendData = Chr(0) + Chr(0) + Chr(0) + Chr(32)
    End If
    
    'Senden starten
    Sende3964 11

   
    
End Function
Function DatenQuittung()
    
    'Header des Folgetrelegramms
    SendData = Hex(0) + Chr(0) + Chr(0) + Chr(0)
    
    'Senden starten
    Sende3964 11

End Function

Function FolgeTelegramm()
    
    'Header des Folgetelegramms
    SendData = Chr(15) + Chr(0) + "AD"

    'Senden starten
    Sende3964 11

End Function

Function GetDBWrite() As Integer
    If SendStep > 0 Then
        'Senden luft noch
        GetDBWrite = 1
    Else
        If SendStep = 0 Then
           GetDBWrite = 0
           If LastSendError = 0 Then
              Exit Function
           Else
           
           End If
        
        End If
        
    End If
End Function
