VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} Testbeispiel 
   Caption         =   "Testbeispiel"
   ClientHeight    =   7170
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6390
   OleObjectBlob   =   "S7ProSim.dsx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "Testbeispiel"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'=======================================
'DECLARATIONPART OF THE FORM
'=======================================

'Variables must be declared
Option Explicit

'Default Error Code Values of S7ProSim
'---------------------------------------
Private Const S_OK = &H0
Private Const PS_E_FAIL = &H80004005
Private Const PS_E_INVBYTENDX = &H80040201
Private Const PS_E_INVBYTECOUNT = &H80040202
Private Const PS_E_READFAILED = &H80040203
Private Const PS_E_WRITEFAILED = &H80040204
Private Const PS_E_INVBITNDX = &H80040205
Private Const PS_E_INVTYPE = &H80040206
Private Const PS_E_NOTREGISTERED = &H80040209
Private Const PS_E_NOTSINGLESCAN = &H8004020A
Private Const PS_E_MODENOTPOSSIBLE = &H8004020C
Private Const PS_E_NOTIFICATION_EXIST = &H8004020D
Private Const PS_E_PLCSIMNOTRUNNING = &H8004020E
Private Const PS_S_ALLREADSNOTPOSSIBLE = &H8004020F
Private Const PS_S_ALLWRITESNOTPOSSIBLE = &H80040210
Private Const PS_E_NOTCONNECTED = &H80040211
Private Const PS_E_POWEROFF = &H80040212

'Default Error Text
'---------------------------------------
Private Const MSG_OK = "&H0: Method was successful"
Private Const MSG_FAIL = "&H80004005: Unknown error occurred"
Private Const MSG_INVBYTENDX = _
    "&H80040201: ByteIndex value out of Range"
Private Const MSG_INVBYTECOUNT = _
    "&H80040202: ByteIndex + size of Data array out of range or BytesToRead out of Range"
Private Const MSG_READFAILED = _
    "&H80040203: S7-PLCSIM refused read request"
Private Const MSG_WRITEFAILED = _
    "&H80040204: S7-PLCSIM refused write request"
Private Const MSG_INVBITNDX = _
    "&H80040205: BitIndex value out of range"
Private Const MSG_INVTYPE = "&H80040206: Invalid data type"
Private Const MSG_NOTREGISTERED = _
    "&H80040209: The application is not registered"
Private Const MSG_NOTSINGLESCAN = _
    "&H8004020A: S7-PLCSIM is not in single scan mode"
Private Const MSG_NOTIFICATION_EXIST = _
    "&H8004020D: Application is already registered"
Private Const MSG_PLCSIMNOTRUNNING = _
    "&H8004020E: S7-PLCSIM is not in Run or Run-P mode"
Private Const MSG_ALLREADSNOTPOSSIBLE = _
    "&H8004020F: Only the configured outputs could be read successful"
Private Const MSG_ALLWRITESNOTPOSSIBLE = _
    "&H80040210: Only the configured inputs could be written successful"
Private Const MSG_NOTCONNECTED = _
    "&H80040211: The S7ProSim control is not connected to S7-PLCSIM"
Private Const MSG_POWEROFF = _
    "&H80040212: S7-PLCSIM is in Power-off state"

Private Sub cmdAbout_Click()
    S7ProSim1.AboutBox
End Sub

'=======================================
'CODE FOR THE BUTTONS
'=======================================

'cmdAutoConnectEnd
'---------------------------------------
Private Sub cmdAutoConnectTrueEnd_Click()
    S7ProSim1.AutoConnect = True    '***T??
    '***** If the AutoConnect property is set to true
End Sub

'cmdAutoConnectTrueStart
'---------------------------------------
Private Sub cmdAutoConnectTrueStart_Click()
    S7ProSim1.AutoConnect = True
End Sub

'cmdCalculateValuesOfProcessSimulation
'---------------------------------------
Private Sub cmdCalculateValuesOfProcessSimulation_Click()
    '***** TODO by the User                                 *****
    '***** In this function you have to implement the       *****
    '***** Code for the Process Simulation. Take the        *****
    '***** values from the Outputs of S7-PLCSIM and         *****
    '***** calculate the new values for the Input of        *****
    '***** S7-PLCSIM.                                       *****

End Sub

'cmdConnect
'---------------------------------------
Private Sub cmdConnect_Click()
    Dim errConnect As Long
    
    errConnect = S7ProSim1.Connect
    If errConnect = S_OK Then
        MsgBox MSG_OK, vbInformation, "S7ProSim Example"
    Else
        ShowError errConnect
    End If
End Sub

'cmdDisconnect
'---------------------------------------
Private Sub cmdDisconnect_Click()
    Dim errDisconnect As Long
    
    errDisconnect = S7ProSim1.Disconnect

    If errDisconnect = S_OK Then
        MsgBox MSG_OK, vbInformation, "S7ProSim Example"
    Else
        ShowError errDisconnect
    End If
End Sub

'cmdEnableTrue
'---------------------------------------
Private Sub cmdEnabelTrue_Click()
S7ProSim1.Enabled = True
End Sub

'cmdEnableFalse
'---------------------------------------
Private Sub cmdEnableFalse_Click()
    S7ProSim1.Enabled = False
End Sub


Private Sub cmdExecuteSingleScan_Click()
    Dim errExecuteSingleScan As Long
    
    errExecuteSingleScan = S7ProSim1.ExecuteSingleScan
    If errExecuteSingleScan = S_OK Then
        'MsgBox MSG_OK, vbInformation, "S7ProSim Example"
    Else
        ShowError errExecuteSingleScan
    End If
End Sub

'cmdReadOutputImage
'---------------------------------------
Private Sub cmdReadOutputImage_Click()
    'Long
    Dim errReadOutputImage As Long
    Dim lStartIndex As Long
    Dim lElementsToRead As Long
    'ImageDataTypeConstants
    Dim DataType 'As ImageDataTypeConstants
    'Variant
    Dim vData As Variant
    
    '***** Read 2 Bytes at the starting address Q 8.0 *****
    DataType = S7Byte                   'Read type Byte
    lStartIndex = 8                     'Start at address Q 8.0
    lElementsToRead = 2                 'Read 2 elements (Bytes)
    
    errReadOutputImage = S7ProSim1.ReadOuputImage(lStartIndex, _
                                lElementsToRead, DataType, vData)

    If errReadOutputImage = S_OK Then
        MsgBox "Value of QB 8 is: " & CByte(vData(0)) & vbCrLf & _
                "Value of QB 9 is: " & CByte(vData(1)), _
                vbInformation, "S7ProSim Example"
    Else
        ShowError errReadOutputImage
    End If
    
    '***** Read 2 Words at the starting address Q 10.0 *****
    DataType = S7Word                   'Read type Word
    lStartIndex = 10                    'Start at address Q 10.0
    lElementsToRead = 2                 'Read 2 Elements (Words)

    
    errReadOutputImage = S7ProSim1.ReadOuputImage(lStartIndex, _
                                lElementsToRead, DataType, vData)
    If errReadOutputImage = S_OK Then
        MsgBox "Value of QW 10 is: " & CInt(vData(0)) & vbCrLf & _
                "Value of QW 12 is: " & CInt(vData(1)), _
                vbInformation, "S7ProSim Example"
    Else
        ShowError errReadOutputImage
    End If
    
    '***** Read 2 DoubleWords at the starting address Q 14.0 *****

    DataType = S7DoubleWord             'Read type DoubleWord
    lStartIndex = 14                    'Start at addresse Q 14.0
    lElementsToRead = 2                 'Read 2 Elements (DoubleWords)
    
    errReadOutputImage = S7ProSim1.ReadOuputImage(lStartIndex, _
                                lElementsToRead, DataType, vData)
    If errReadOutputImage = S_OK Then
        MsgBox "Value of QD 14 is: " & CLng(vData(0)) & vbCrLf & _
                "Value of QD 18 is: " & CLng(vData(1)), _
                vbInformation, "S7ProSim Example"
    Else
        ShowError errReadOutputImage
    End If
    
    '***** After this section the calculations for the      *****
    '***** Process Simulation can be done if the return     *****
    '***** value is S_OK.                                   *****
End Sub

'cmdReadOutputPoint
'---------------------------------------
Private Sub cmdReadOutputPoint_Click()
    'Long
    Dim errReadOutputPoint As Long
    Dim lByteIndex As Long
    Dim lBitIndex As Long
    'PointDataTypeConstants
    Dim DataType 'As PointDataTypeConstants
    'Variant
    Dim vData As Variant
    
    '***** Read the Bit at the address Q 0.5 *****
    lByteIndex = 0                  'Start at address 0.0
    lBitIndex = 5                   'Read specific Bit 5 (of Byte 0)
    DataType = S7_Bit               'Read type Bit
    
    errReadOutputPoint = S7ProSim1.ReadOutputPoint(lByteIndex, _
                                    lBitIndex, DataType, vData)
    If errReadOutputPoint = S_OK Then
        MsgBox "The current value of Q 0.5 is: " & CInt(vData), _
            vbInformation, "S7ProSim Example"
    Else
        ShowError errReadOutputPoint
    End If
    
    '***** Read the Byte at the address Q 1.0 *****
    lByteIndex = 1                  'Start at address 1.0
    DataType = S7_Byte              'Read type Byte
    
    errReadOutputPoint = S7ProSim1.ReadOutputPoint(lByteIndex, _
                                    lBitIndex, DataType, vData)
    If errReadOutputPoint = S_OK Then
        MsgBox "The current value of QB 1 is: " & CByte(vData), _
            vbInformation, "S7ProSim Example"
    Else
        ShowError errReadOutputPoint
    End If
    
    '***** Read the Word at the address Q 2.0 *****
    lByteIndex = 2                  'Start at address 2.0
    DataType = S7_Word              'Read type Word
    
    errReadOutputPoint = S7ProSim1.ReadOutputPoint(lByteIndex, _
                                    lBitIndex, DataType, vData)
    If errReadOutputPoint = S_OK Then
        MsgBox "The current value of QW 2 is: " & CInt(vData), _
            vbInformation, "S7ProSim Example"
    Else
        ShowError errReadOutputPoint
    End If
    
    '***** Read the DoubleWord at the address Q 4.0 *****
    lByteIndex = 4                  'Start at address 4.0
    DataType = S7_DoubleWord        'Read type DoubleWord
    
    errReadOutputPoint = S7ProSim1.ReadOutputPoint(lByteIndex, _
                                    lBitIndex, DataType, vData)
    If errReadOutputPoint = S_OK Then
        MsgBox "The current value of QD 4 is: " & CLng(vData), _
            vbInformation, "S7ProSim Example"
    Else
        ShowError errReadOutputPoint
    End If
  
    '***** After this section the calculations for the      *****
    '***** Process Simulation can be done if the return     *****
    '***** value is S_OK.                                   *****

End Sub

'cmdScanModeCont
'---------------------------------------
Private Sub cmdScanModeCont_Click()
    S7ProSim1.ScanMode = ContinuousScan
End Sub

'cmdScanModeSingle
'---------------------------------------
Private Sub cmdScanModeSingle_Click()
    S7ProSim1.ScanMode = SingleScan
End Sub

'cmdWriteInputImage
'---------------------------------------
Private Sub cmdWriteInputImage_Click()
    'Byte
    Dim cByteArray(0 To 1) As Byte
    'Integer
    Dim iWordArray(0 To 1) As Integer

    'Long
    Dim errWriteInputImage As Long
    Dim lDoubleWordArray(0 To 1) As Long
    Dim lStartIndex As Long
    'Variant
    Dim vData As Variant
    
    '***** Write 2 Bytes and start at address I 8.0 *****
    cByteArray(0) = 8           'Write 8 in first element (Byte)
    cByteArray(1) = 9           'Write 9 in second element (Byte)
    lStartIndex = 8             'Start at address I 8.0
    
    vData = cByteArray
    errWriteInputImage = S7ProSim1.WriteInputImage(lStartIndex, _
                                                        vData)
    '***** After this section the calculations for the      *****
    '***** Process Simulation can be done if the return     *****
    '***** value is S_OK.                                   *****
    If errWriteInputImage = S_OK Then
        MsgBox MSG_OK, vbInformation, "S7ProSim Example"
    Else
        ShowError errWriteInputImage
    End If
    
    '***** Write 2 Words and start at address I 10.0 *****

    iWordArray(0) = 10          'Write 10 in first element (Word)
    iWordArray(1) = 12          'Write 12 in second element (Word)
    lStartIndex = 10            'Start at address I 10.0
    
    vData = iWordArray
    errWriteInputImage = S7ProSim1.WriteInputImage(lStartIndex, _
                                                        vData)
    If errWriteInputImage = S_OK Then
        MsgBox MSG_OK, vbInformation, "S7ProSim Example"
    Else
        ShowError errWriteInputImage

    End If
    
    '***** Write 2 DouleWords and start at address I 14.0 *****
    lDoubleWordArray(0) = 14   'Write 14 in first element (DoubleWord)
    lDoubleWordArray(1) = 18   'Write 18 in second element (DoubleWord)
    lStartIndex = 14           'Start at address I 14.0
    
    vData = lDoubleWordArray
    errWriteInputImage = S7ProSim1.WriteInputImage(lStartIndex, _
                                                        vData)
    If errWriteInputImage = S_OK Then

        MsgBox MSG_OK, vbInformation, "S7ProSim Example"
    Else
        ShowError errWriteInputImage
    End If
End Sub

'cmdWriteInputPoint
'---------------------------------------
Private Sub cmdWriteInputPoint_Click()
    'Boolean
    Dim bBoolIn As Boolean
    'Byte
    Dim cByteIn As Byte
    'Integer
    Dim iWordIn As Integer
    'Long
    Dim errWriteInputPoint As Long
    Dim lBitIndex As Long
    Dim lByteIndex As Long
    Dim lDoubleWordIn As Long

    'Variant
    Dim vData As Variant
    
    '***** Write 1 Bit to the address I 0.5 *****
    bBoolIn = 1                     'Write value 1
    lByteIndex = 0                  'Start at address 0.0
    lBitIndex = 5                   'Write specific Bit 5 (of Byte 0)
    
    vData = bBoolIn
    errWriteInputPoint = S7ProSim1.WriteInputPoint(lByteIndex, _
                                                lBitIndex, vData)
    '***** After this section the calculations for the      *****

    '***** Process Simulation can be done if the return     *****
    '***** value is S_OK.                                   *****
    If errWriteInputPoint = S_OK Then
        MsgBox MSG_OK, vbInformation, "S7ProSim Example"
    Else
        ShowError errWriteInputPoint
    End If
    
    '***** Write 1 Byte to the address I 1.0 *****
    cByteIn = 1                     'Write value 1
    lByteIndex = 1                  'Start at address 1.0
    
    vData = cByteIn

    errWriteInputPoint = S7ProSim1.WriteInputPoint(lByteIndex, _
                                                lBitIndex, vData)
    If errWriteInputPoint = S_OK Then
        MsgBox MSG_OK, vbInformation, "S7ProSim Example"
    Else
        ShowError errWriteInputPoint
    End If
    
    '***** Write 1 Word to the address I 2.0 *****
    iWordIn = 2                     'Write value 2
    lByteIndex = 2                  'Start at address 2.0
    
    vData = iWordIn

    errWriteInputPoint = S7ProSim1.WriteInputPoint(lByteIndex, _
                                                lBitIndex, vData)
    If errWriteInputPoint = S_OK Then
        MsgBox MSG_OK, vbInformation, "S7ProSim Example"
    Else
        ShowError errWriteInputPoint
    End If
    
    '***** Write 1 DoubleWord to the address I 4.0 *****
    lDoubleWordIn = 4               'Write value 4
    lByteIndex = 4                  'Start at address 4.0
    
    vData = lDoubleWordIn

    errWriteInputPoint = S7ProSim1.WriteInputPoint(lByteIndex, _
                                                lBitIndex, vData)
    If errWriteInputPoint = S_OK Then
        MsgBox MSG_OK, vbInformation, "S7ProSim Example"
    Else
        ShowError errWriteInputPoint
    End If
End Sub

Private Sub CommandButton1_Click()
'***T Close UserForm.Testbeispiel
End Sub

'=======================================
'EVENTS IMPLEMENTATION FOR THE CONTROL
'=======================================

'ConnectionError
'---------------------------------------

Private Sub S7ProSim1_ConnectionError(ByVal ControlEngine As String, _
                                        ByVal Error As Long)
    Dim errMessage As String
    errMessage = "Unable to connect to " & ControlEngine & vbCrLf
    errMessage = errMessage & vbCrLf & _
        "Start " & ControlEngine & vbCrLf
    errMessage = errMessage & "and connect with Connect method"
    MsgBox errMessage, vbExclamation, "Connection Error"
End Sub

'PLCStateChanged
'---------------------------------------

Private Sub S7ProSim1_PLCStateChanged(ByVal NewState As String)
    Dim cMessage As String
    
    cMessage = "PLCSIM changed the operating state to " & NewState
    MsgBox cMessage, vbInformation, "S7ProSim Example"
End Sub

'ScanFinished
'---------------------------------------
Private Sub S7ProSim1_ScanFinished(ByVal ScanInfo As Variant)
    Dim cMessage As String
    Dim vArrayInfo As Variant
    '***** Before this section of code, the calculations    *****

    '***** for the Process Simulation should be done.       *****
    vArrayInfo = ScanInfo
    cMessage = "Last scan took " & vArrayInfo(0) & vbCrLf
    cMessage = cMessage & _
        "minimum cyle time " & vArrayInfo(1) & vbCrLf
    cMessage = cMessage & _
        "Largest Execution time took " & vArrayInfo(2) & vbCrLf
    cMessage = cMessage & _
        "Average scan took " & vArrayInfo(3)
    MsgBox cMessage, vbInformation, "S7ProSim Example"
End Sub


'=======================================
'PRIVATE SUBs
'=======================================

'ShowError
'---------------------------------------
Private Sub ShowError(ErrorNumber)
    Select Case ErrorNumber
        Case PS_E_FAIL
            MsgBox MSG_FAIL, vbExclamation, "S7ProSim Example"
        Case PS_E_INVBYTENDX
            MsgBox MSG_INVBYTENDX, vbExclamation, "S7ProSim Example"
        Case PS_E_INVBYTECOUNT
            MsgBox MSG_INVBYTECOUNT, vbExclamation, "S7ProSim Example"
        Case PS_E_READFAILED
            MsgBox MSG_READFAILED, vbExclamation, "S7ProSim Example"
        Case PS_E_WRITEFAILED
            MsgBox MSG_WRITEFAILED, vbExclamation, "S7ProSim Example"
        Case PS_E_INVBITNDX
            MsgBox MSG_INVBITNDX, vbExclamation, "S7ProSim Example"
        Case PS_E_INVTYPE
            MsgBox MSG_INVTYPE, vbExclamation, "S7ProSim Example"
        Case PS_E_NOTREGISTERED
            MsgBox MSG_NOTREGISTERED, vbExclamation, "S7ProSim Example"
        Case PS_E_NOTSINGLESCAN
            MsgBox MSG_NOTSINGLESCAN, vbExclamation, "S7ProSim Example"
        Case PS_E_NOTIFICATION_EXIST
            MsgBox MSG_NOTIFICATION_EXIST, vbExclamation, _
                "S7ProSim Example"
        Case PS_E_PLCSIMNOTRUNNING
            MsgBox MSG_PLCSIMNOTRUNNING, vbExclamation, _
                "S7ProSim Example"
        Case PS_S_ALLREADSNOTPOSSIBLE
            MsgBox MSG_ALLREADSNOTPOSSIBLE, vbExclamation, _
                "S7ProSim Example"
        Case PS_S_ALLWRITESNOTPOSSIBLE
            MsgBox MSG_ALLWRITESNOTPOSSIBLE, vbExclamation, _
                "S7ProSim Example"
        Case PS_E_NOTCONNECTED
            MsgBox MSG_NOTCONNECTED, vbExclamation, "S7ProSim Example"
        Case PS_E_POWEROFF
            MsgBox MSG_POWEROFF, vbExclamation, "S7ProSim Example"
        Case Else
            MsgBox "System Error occured: &H" & Hex(ErrorNumber), _
                vbExclamation, "S7ProSim Example"
    End Select
End Sub

Private Sub UserForm_Click()
MsgBox "Klick nicht daneben!", vbInformation, "STEP 7-ProSim"
End Sub
